/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.compiler.Mork;
import net.oneandone.mork.compiler.Specification;
import net.oneandone.mork.compiler.Syntax;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.grammar.Rule;
import net.oneandone.mork.mapping.Definition;
import net.oneandone.mork.mapping.Library;
import net.oneandone.mork.mapping.Path;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.mork.reflect.Identity;
import net.oneandone.mork.reflect.Selection;
import net.oneandone.mork.regexpr.ActionException;
import net.oneandone.mork.regexpr.Range;
import net.oneandone.mork.regexpr.Sequence;
import net.oneandone.mork.semantics.BuiltIn;
import net.oneandone.mork.semantics.IllegalLiteral;
import net.oneandone.sushi.util.IntBitSet;

public class Stubs {
    public static final String NO_SUCH_ATTRIBUTE = "No such attribute";
    public static final String NO_SUCH_SYMBOL_OR_ATTRIBUTE = "No such symbol or attribute";
    public static final String UNDEFINED_SYMBOL = "Undefined symbol";
    public static final String INVALID_CHARACTER = "invalid character code";
    public static final String ILLEGAL_INLINE = "defining attributes for inline symbols is illegal";

    public static Object sideEffect(List a, List b, List c, List d) {
        return null;
    }

    public static Grammar getIFGrammar(Syntax syntax) {
        return syntax.getGrammar();
    }

    public static StringArrayList getIFSymbolTable(Syntax syntax) {
        return syntax.getGrammar().getSymbolTable();
    }

    public static Syntax loadSyntax(Object mork, String fileName) throws GenericException, IllegalLiteral, IOException {
        return ((Mork)mork).loadSyntax(fileName);
    }

    public static char toChar(int num) throws GenericException {
        if (num < 0 || num > 65535) {
            throw new GenericException(INVALID_CHARACTER, "" + num);
        }
        return (char)num;
    }

    public static int symbolRef(StringArrayList table, String name) throws GenericException {
        int result = table.indexOf(name);
        if (result == -1) {
            throw new GenericException(UNDEFINED_SYMBOL, name);
        }
        return result;
    }

    public static IntBitSet symbolSet(int[] lst) throws ActionException {
        IntBitSet result = new IntBitSet();
        for (int i = 0; i < lst.length; ++i) {
            int sym = lst[i];
            if (result.contains(sym)) {
                throw new ActionException("duplicate symbol: " + sym);
            }
            result.add(sym);
        }
        return result;
    }

    public static String[] keywordList(String[] keywords) {
        return keywords;
    }

    public static Definition createDefinition(Grammar grm, StringArrayList symbolTable, int symbol, String name, Object constr) throws GenericException {
        boolean main;
        boolean bl = main = symbolTable.indexOf(name) == symbol;
        if (grm.isTerminal(symbol)) {
            IntBitSet terminals = new IntBitSet();
            grm.getUsedTerminals(terminals);
            if (!terminals.contains(symbol)) {
                throw new GenericException(ILLEGAL_INLINE);
            }
        }
        return new Definition(main, grm, symbol, name, constr);
    }

    public static Object step(int move, String symbolOrAttribute) {
        return new Object[]{new Integer(move), symbolOrAttribute};
    }

    private static int[] getMoves(Object[] steps) {
        int[] moves = new int[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            Object[] step = (Object[])steps[i];
            moves[i] = (Integer)step[0];
        }
        return moves;
    }

    private static String[] getSymbolsOrAttributes(Object[] steps) {
        String[] sas = new String[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            Object[] step = (Object[])steps[i];
            sas[i] = (String)step[1];
        }
        return sas;
    }

    public static Object implicitPath(Specification spec, Definition def) throws GenericException {
        spec.translateDefaultPushPath(def);
        return null;
    }

    public static Object localPath(Specification spec, Definition srcDef, int symbol, String name) throws GenericException {
        Definition user = spec.lookup(symbol, name);
        if (user == null) {
            throw new GenericException(NO_SUCH_ATTRIBUTE, name);
        }
        Path.translate(spec.getSyntax(), srcDef, user);
        return null;
    }

    public static Object normalPath(Definition source, Specification spec, Object[] steps) throws GenericException {
        Definition target;
        String str;
        StringArrayList symbolTable = spec.getSyntax().getGrammar().getSymbolTable();
        int[] moves = Stubs.getMoves(steps);
        String[] symbolsOrAttributes = Stubs.getSymbolsOrAttributes(steps);
        int[] symbols = new int[symbolsOrAttributes.length - 1];
        for (int i = 0; i < symbols.length; ++i) {
            str = symbolsOrAttributes[i];
            target = spec.lookup(str);
            if (target != null) {
                symbols[i] = target.getAttribute().symbol;
                continue;
            }
            symbols[i] = symbolTable.indexOf(str);
            if (symbols[i] != -1) continue;
            throw new GenericException(NO_SUCH_SYMBOL_OR_ATTRIBUTE, str);
        }
        str = symbolsOrAttributes[symbolsOrAttributes.length - 1];
        target = spec.lookup(str);
        if (target == null) {
            throw new GenericException(NO_SUCH_ATTRIBUTE, str);
        }
        Path.translate(spec.getSyntax(), source, moves, symbols, target, 0);
        return null;
    }

    public static Selection copyFunctionRef(Library lib, String name) throws GenericException {
        Selection sel = lib.lookupClass(name);
        Class type = sel.calcResult();
        Identity id = new Identity(name, type, type);
        return new Selection(id);
    }

    public static String name(String[] lst) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < lst.length; ++i) {
            if (i > 0) {
                buf.append('.');
            }
            buf.append(lst[i]);
        }
        return buf.toString();
    }

    public static Range range(char first, Character second) {
        if (second == null) {
            return new Range(first);
        }
        return new Range(first, second.charValue());
    }

    public static StringArrayList symbolTable(String[] a, String[] b) {
        StringArrayList result = new StringArrayList();
        Stubs.add(result, a);
        Stubs.add(result, b);
        return result;
    }

    public static void add(StringArrayList symbolTable, String[] symbols) {
        for (int i = 0; i < symbols.length; ++i) {
            String str = symbols[i];
            if (symbolTable.indexOf(str) != -1) continue;
            symbolTable.add(str);
        }
    }

    public static Syntax createSyntax(StringArrayList symbolTable, Rule[] parserRules, boolean prio, IntBitSet whiteSymbols, Rule[] explScannerRules, List rawKeywords) throws GenericException {
        return new Syntax(symbolTable, parserRules, prio, whiteSymbols, Stubs.scannerRules(rawKeywords, explScannerRules));
    }

    public static Object[] keyword(int symbol, String name) throws IllegalLiteral {
        String str = BuiltIn.parseString(name);
        return new Object[]{new Integer(symbol), str};
    }

    public static Rule[] scannerRules(List rawKeywords, Rule[] rules) throws GenericException {
        IntBitSet doneSymbols = new IntBitSet();
        StringArrayList doneKeywords = new StringArrayList();
        int max = rawKeywords.size();
        ArrayList<Rule> keywords = new ArrayList<Rule>();
        for (int i = 0; i < max; ++i) {
            Object[] pair = (Object[])rawKeywords.get(i);
            int symbol = (Integer)pair[0];
            if (doneSymbols.contains(symbol)) continue;
            doneSymbols.add(symbol);
            String kw = (String)pair[1];
            if (doneKeywords.indexOf(kw) != -1) {
                throw new GenericException("ambiguous String literal: " + kw);
            }
            keywords.add(new Rule(symbol, Sequence.createKeyword(kw)));
        }
        Rule[] all = new Rule[keywords.size() + rules.length];
        keywords.toArray(all);
        System.arraycopy(rules, 0, all, keywords.size(), rules.length);
        return all;
    }

    public static String attributeName(StringArrayList symbolTable, int recordSymbol, String attributeName) {
        if (attributeName != null) {
            return attributeName;
        }
        return symbolTable.get(recordSymbol);
    }

    public static String attributeName(StringArrayList symbolTable, int recordSymbol) {
        return Stubs.attributeName(symbolTable, recordSymbol, null);
    }
}

