/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.compiler;

import java.util.Map;
import net.oneandone.mork.compiler.ConflictHandler;
import net.oneandone.mork.compiler.ConflictResolver;
import net.oneandone.mork.compiler.Output;
import net.oneandone.mork.grammar.Ebnf;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.grammar.PrefixSet;
import net.oneandone.mork.grammar.Rule;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.mork.parser.Parser;
import net.oneandone.mork.parser.ParserTable;
import net.oneandone.mork.pda.PDA;
import net.oneandone.mork.scanner.FABuilder;
import net.oneandone.mork.scanner.Modes;
import net.oneandone.mork.scanner.ScannerFactory;
import net.oneandone.sushi.util.IntBitSet;

public class Syntax {
    public static final String CONFLICT = "lr(k) conflict:\n";
    private Grammar grammar;
    private boolean priorities;
    private IntBitSet whiteSymbols;
    private Rule[] scannerRules;

    public Syntax(StringArrayList symbolTable, Rule[] parserRules, boolean priorities, IntBitSet whiteSymbols, Rule[] scannerRules) throws GenericException {
        if (parserRules.length == 0) {
            throw new IllegalArgumentException();
        }
        this.grammar = Ebnf.translate(parserRules, symbolTable);
        this.priorities = priorities;
        this.whiteSymbols = whiteSymbols != null ? whiteSymbols : new IntBitSet();
        this.scannerRules = scannerRules;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public Parser translate(int k, int threadCount, Output output) throws GenericException {
        long started = System.currentTimeMillis();
        output.verbose("computing firsts");
        Map<Integer, PrefixSet> firsts = this.grammar.firsts(k);
        output.verbose("creating pda, " + threadCount + " threads");
        PDA pda = PDA.create(this.grammar, firsts, k, threadCount);
        output.verbose("done: " + pda.size() + " states, " + (System.currentTimeMillis() - started) + " ms");
        int symbolCount = Math.max(this.grammar.getSymbolCount(), this.whiteSymbols.last() + 1);
        ConflictHandler handler = new ConflictHandler(this.grammar);
        ParserTable parserTable = pda.createTable(symbolCount, handler);
        parserTable.addWhitespace(this.whiteSymbols);
        StringArrayList symbolTable = this.grammar.getSymbolTable();
        if (output.listing != null) {
            output.listing.println("\nSymbols:");
            output.listing.println(symbolTable.toString());
            output.listing.println("\nGrammar:");
            output.listing.println(this.grammar.toString());
            output.listing.println("\nFirst Sets:");
            for (Map.Entry<Integer, PrefixSet> entry : firsts.entrySet()) {
                output.listing.println(symbolTable.get(entry.getKey()) + ":\t" + entry.getValue().toString(symbolTable));
            }
            output.listing.println("\nAutomaton:");
            pda.print(output.listing);
        }
        if (output.statistics != null) {
            output.statistics.println();
            output.statistics.println("parser statistics");
            output.statistics.println("  states: " + pda.size());
            output.statistics.println("  table: [symbols=" + parserTable.getSymbolCount() + "][states=" + parserTable.getStateCount() + "]");
            output.statistics.println("  lr(1) conflicts: " + handler.resolvers());
            pda.statistics(output.statistics);
        }
        ConflictResolver[] resolvers = handler.report(output, this.grammar);
        pda = null;
        output.verbose("processing scanner section");
        IntBitSet usedTerminals = new IntBitSet();
        this.grammar.getUsedTerminals(usedTerminals);
        usedTerminals.addAll(this.whiteSymbols);
        output.verbose("generating scanner");
        FABuilder builder = FABuilder.run(this.scannerRules, usedTerminals, symbolTable, output.verbose);
        output.listing("inline symbols: " + builder.getInlines());
        if (this.priorities) {
            output.verbose("use priorities");
            Modes.resolveScannerConflicts(builder.getFA(), this.scannerRules);
        }
        ScannerFactory scannerFactory = ScannerFactory.create(builder.getFA(), builder.getErrorState(), parserTable, this.whiteSymbols, output.verbose, output.listing);
        if (output.statistics != null) {
            output.statistics.println();
            output.statistics.println("scanner statistics");
            output.statistics.println("  fa states : " + builder.getFA().size());
            output.statistics.println("  table: char[" + scannerFactory.size() + "]");
        }
        output.verbose("scanner done");
        IntBitSet usedSymbols = new IntBitSet(this.whiteSymbols);
        usedSymbols.addAll(builder.getInlines());
        this.grammar.check(this.grammar.getStart(), usedSymbols, symbolTable.toList());
        return new Parser(parserTable, resolvers, scannerFactory);
    }
}

