/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.grammar;

import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.grammar.Rule;
import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.mork.regexpr.Action;
import net.oneandone.mork.regexpr.ActionException;

public class Ebnf
extends Action {
    private int helper;

    public static Grammar translate(Rule[] rules, StringArrayList symbolTable) throws ActionException {
        int firstHelper = symbolTable.size();
        Grammar buffer = new Grammar(rules[0].getLeft(), symbolTable);
        Ebnf builder = new Ebnf(firstHelper);
        for (int i = 0; i < rules.length; ++i) {
            Grammar tmp = (Grammar)rules[i].getRight().visit(builder);
            buffer.addProduction(new int[]{rules[i].getLeft(), tmp.getStart()});
            buffer.addProductions(tmp);
            buffer.expandSymbol(tmp.getStart());
            buffer.removeProductions(tmp.getStart());
        }
        int lastHelper = builder.getHelper() - 1;
        buffer.removeDuplicateSymbols(firstHelper, lastHelper);
        buffer.removeDuplicateRules();
        buffer.packSymbols(firstHelper, lastHelper + 1);
        return buffer;
    }

    public Ebnf(int helper) {
        this.helper = helper;
    }

    public int getHelper() {
        return this.helper;
    }

    @Override
    public Object choice(Object[] body) {
        Grammar result = new Grammar(this.helper);
        for (int i = 0; i < body.length; ++i) {
            Grammar tmp = (Grammar)body[i];
            result.addProduction(new int[]{this.helper, tmp.getStart()});
            result.addProductions(tmp);
            result.expandSymbol(tmp.getStart());
            result.removeProductions(tmp.getStart());
        }
        ++this.helper;
        return result;
    }

    @Override
    public Object sequence(Object[] body) {
        Grammar tmp;
        int i;
        Grammar result = new Grammar(this.helper);
        int[] prod = new int[body.length + 1];
        prod[0] = this.helper;
        for (i = 0; i < body.length; ++i) {
            tmp = (Grammar)body[i];
            prod[i + 1] = tmp.getStart();
        }
        result.addProduction(prod);
        for (i = 0; i < body.length; ++i) {
            tmp = (Grammar)body[i];
            result.addProductions(tmp);
            result.expandSymbol(tmp.getStart());
            result.removeProductions(tmp.getStart());
        }
        ++this.helper;
        return result;
    }

    @Override
    public Object loop(Object rawBody) {
        Grammar body = (Grammar)rawBody;
        Grammar result = new Grammar(this.helper + 1);
        result.addProduction(new int[]{this.helper + 1, this.helper});
        result.addProduction(new int[]{this.helper, this.helper, body.getStart()});
        result.addProduction(new int[]{this.helper, body.getStart()});
        result.addProductions(body);
        result.expandSymbol(body.getStart());
        result.removeProductions(body.getStart());
        this.helper += 2;
        return result;
    }

    @Override
    public Object symbol(int symbol) {
        Grammar result = new Grammar(this.helper);
        int[] nArray = new int[]{this.helper++, symbol};
        result.addProduction(nArray);
        return result;
    }

    @Override
    public Object range(char first, char last) throws ActionException {
        if (first == last) {
            throw new ActionException("illegal character literal in parser section: char code=" + first + ":\nuse a string literal (double quotes instead of single quotes!)");
        }
        throw new ActionException("illegal range in parser section: " + first + ".." + last + ":\ndefine a helper symbol for this range in the scanner section and use\nthe helper symbol instead. ");
    }

    @Override
    public Object without(Object left, Object right) throws ActionException {
        throw new ActionException("illegal without operator");
    }
}

