/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oneandone.mork.grammar.Concat;
import net.oneandone.mork.grammar.GrammarBase;
import net.oneandone.mork.grammar.PrefixSet;
import net.oneandone.mork.grammar.Symbol;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.sushi.util.IntArrayList;
import net.oneandone.sushi.util.IntBitSet;
import net.oneandone.sushi.util.Separator;
import net.oneandone.sushi.util.Strings;

public class Grammar
extends GrammarBase {
    public static final String NOT_PRODUCTIVE = "symbol(s) not productive: ";
    public static final String NOT_REACHABLE = "symbol(s) not reachable: ";
    private int start;
    private final StringArrayList symbolTable;

    public static Grammar forProductions(String ... prods) {
        Grammar grammar = new Grammar();
        StringArrayList symbolTable = grammar.symbolTable;
        int idx = 0;
        for (int p = 0; p < prods.length; ++p) {
            String[] stringProd = Strings.toArray((Collection)Separator.SPACE.split((CharSequence)prods[p]));
            if (stringProd.length == 0) {
                throw new IllegalArgumentException();
            }
            int[] prod = new int[stringProd.length];
            for (int ofs = prod.length - 1; ofs >= 0; --ofs) {
                String s = stringProd[ofs];
                idx = symbolTable.indexOf(s);
                if (idx == -1) {
                    idx = symbolTable.size();
                    symbolTable.add(s);
                }
                prod[ofs] = idx;
            }
            if (p == 0) {
                grammar.start = idx;
            }
            grammar.addProduction(prod);
        }
        return grammar;
    }

    public Grammar() {
        this(-1);
    }

    public Grammar(int start) {
        this(start, new StringArrayList());
    }

    public Grammar(int start, StringArrayList symbolTable) {
        this.start = start;
        this.symbolTable = symbolTable;
    }

    public void check(int startSym, IntBitSet usedSymbols, List<String> symbolTable) throws GenericException {
        IntBitSet tmp = new IntBitSet();
        IntBitSet all = new IntBitSet();
        this.getTerminals(tmp);
        this.addTerminable(tmp);
        all.addAll(tmp);
        this.getNonterminals(all);
        all.removeAll(tmp);
        if (!all.isEmpty()) {
            throw new GenericException(NOT_PRODUCTIVE + all.toString(symbolTable));
        }
        tmp = new IntBitSet();
        this.addReachable(startSym, tmp, null);
        all = new IntBitSet();
        this.getTerminals(all);
        this.getNonterminals(all);
        all.removeAll(tmp);
        all.removeAll(usedSymbols);
        if (!all.isEmpty()) {
            throw new GenericException(NOT_REACHABLE + all.toString(symbolTable));
        }
    }

    public int getStart() {
        return this.start;
    }

    public StringArrayList getSymbolTable() {
        return this.symbolTable;
    }

    public int getLength(int prod) {
        return this.getProduction(prod).length - 1;
    }

    public int getSymbol(int prod, int ofs) {
        return this.getProduction(prod)[ofs];
    }

    public int getLeft(int prod) {
        return this.getSymbol(prod, 0);
    }

    public int getRight(int prod, int ofs) {
        return this.getSymbol(prod, ofs + 1);
    }

    private void getRight(int prod, IntBitSet result) {
        int[] production = this.getProduction(prod);
        for (int i = 1; i < production.length; ++i) {
            result.add(production[i]);
        }
    }

    public int getAlternativeCount(int sym) {
        return this.getSymbol((int)sym).alternatives.length;
    }

    public int getAlternative(int sym, int no) {
        return this.getSymbol((int)sym).alternatives[no];
    }

    public int getUserCount(int sym) {
        return this.getSymbol((int)sym).users.length;
    }

    public int getUser(int sym, int no) {
        return this.getSymbol((int)sym).users[no];
    }

    public int getUserOfsCount(int sym, int no) {
        return this.getSymbol((int)sym).userOfs[no].length;
    }

    public int getUserOfs(int sym, int no, int idx) {
        return this.getSymbol((int)sym).userOfs[no][idx];
    }

    public int getSymbolCount() {
        return this.getSymbols().length;
    }

    public void getTerminals(IntBitSet result) {
        int max = this.getSymbolCount();
        for (int i = 0; i < max; ++i) {
            if (!this.isTerminal(i)) continue;
            result.add(i);
        }
    }

    public void getUsedTerminals(IntBitSet result) {
        int max = this.getSymbolCount();
        for (int i = 0; i < max; ++i) {
            if (!this.isUsedTerminal(i)) continue;
            result.add(i);
        }
    }

    public void getNonterminals(IntBitSet result) {
        int max = this.getSymbolCount();
        for (int i = 0; i < max; ++i) {
            if (!this.isNonterminal(i)) continue;
            result.add(i);
        }
    }

    public void getSymbols(IntBitSet result) {
        result.addRange(0, this.getSymbolCount() - 1);
    }

    public boolean isTerminal(int sym) {
        return this.getSymbol((int)sym).alternatives.length == 0;
    }

    public boolean isUsedTerminal(int sym) {
        Symbol s = this.getSymbol(sym);
        return s.alternatives.length == 0 && s.users.length > 0;
    }

    public boolean isNonterminal(int sym) {
        return this.getSymbol((int)sym).alternatives.length > 0;
    }

    public void addTerminable(IntBitSet result) {
        boolean progress;
        int max = this.getProductionCount();
        IntBitSet finished = new IntBitSet();
        IntBitSet[] rightSet = new IntBitSet[max];
        this.getTerminals(result);
        do {
            progress = false;
            for (int p = 0; p < max; ++p) {
                if (finished.contains(p)) continue;
                if (rightSet[p] == null) {
                    rightSet[p] = new IntBitSet();
                    this.getRight(p, rightSet[p]);
                }
                rightSet[p].removeAll(result);
                if (!rightSet[p].isEmpty()) continue;
                finished.add(p);
                if (result.contains(this.getLeft(p))) continue;
                progress = true;
                result.add(this.getLeft(p));
            }
        } while (progress);
    }

    public void addReachable(int sym, IntBitSet result, IntBitSet recurse) {
        if (!result.contains(sym)) {
            result.add(sym);
            if (recurse == null || recurse.contains(sym)) {
                int maxAlt = this.getAlternativeCount(sym);
                for (int alt = 0; alt < maxAlt; ++alt) {
                    int prod = this.getAlternative(sym, alt);
                    int maxOfs = this.getLength(prod);
                    for (int ofs = 0; ofs < maxOfs; ++ofs) {
                        this.addReachable(this.getRight(prod, ofs), result, recurse);
                    }
                }
            }
        }
    }

    public Map<Integer, PrefixSet> firsts(int k) {
        boolean modified;
        HashMap<Integer, PrefixSet> result = new HashMap<Integer, PrefixSet>();
        IntBitSet terminals = new IntBitSet();
        IntBitSet nonterminals = new IntBitSet();
        this.getTerminals(terminals);
        this.getNonterminals(nonterminals);
        int symbol = terminals.first();
        while (symbol != -1) {
            result.put(symbol, PrefixSet.one(symbol));
            symbol = terminals.next(symbol);
        }
        symbol = nonterminals.first();
        while (symbol != -1) {
            result.put(symbol, new PrefixSet());
            symbol = nonterminals.next(symbol);
        }
        do {
            modified = false;
            for (int p = 0; p < this.getProductionCount(); ++p) {
                PrefixSet first = (PrefixSet)result.get(this.getLeft(p));
                int oldSize = first.size();
                Concat concat = new Concat(k);
                int length = this.getLength(p);
                for (int ofs = 0; ofs < length && !concat.with((PrefixSet)result.get(this.getRight(p, ofs))); ++ofs) {
                }
                first.addAll(concat.result());
                if (first.size() == oldSize) continue;
                modified = true;
            }
        } while (modified);
        symbol = nonterminals.first();
        while (symbol != -1) {
            if (((PrefixSet)result.get(symbol)).size() == 0) {
                throw new IllegalStateException("" + symbol);
            }
            symbol = nonterminals.next(symbol);
        }
        return result;
    }

    public void addProductions(Grammar right) {
        int max = right.getProductionCount();
        for (int i = 0; i < max; ++i) {
            int[] orig = right.getProduction(i);
            int[] copy = new int[orig.length];
            System.arraycopy(orig, 0, copy, 0, orig.length);
            this.addProduction(copy);
        }
    }

    public void removeDuplicateRules() {
        block0: for (int prod1 = this.getProductionCount() - 1; prod1 >= 0; --prod1) {
            int[] tmp1 = this.getProduction(prod1);
            for (int prod2 = prod1 - 1; prod2 >= 0; --prod2) {
                int[] tmp2 = this.getProduction(prod2);
                if (tmp1[0] != tmp2[0] || !Grammar.equal(tmp1, tmp2)) continue;
                this.removeProduction(prod1);
                continue block0;
            }
        }
    }

    public void removeDuplicateSymbols(int first, int last) {
        List lst;
        int sym1;
        ArrayList all = new ArrayList();
        for (sym1 = first; sym1 <= last; ++sym1) {
            all.add(new ArrayList());
        }
        int max = this.getProductionCount();
        for (int prod = 0; prod < max; ++prod) {
            int[] tmp = this.getProduction(prod);
            sym1 = tmp[0];
            if (sym1 < first || sym1 > last) continue;
            lst = (List)all.get(sym1 - first);
            lst.add(tmp);
        }
        block2: for (sym1 = first; sym1 <= last; ++sym1) {
            lst = (List)all.get(sym1 - first);
            if (lst.size() <= 0) continue;
            for (int sym2 = sym1 + 1; sym2 <= last; ++sym2) {
                if (!Grammar.equivalent(lst, (List)all.get(sym2 - first))) continue;
                this.removeProductions(sym1);
                this.renameSymbol(sym1, sym2);
                continue block2;
            }
        }
    }

    private static boolean equivalent(List<int[]> lst1, List<int[]> lst2) {
        int max = lst1.size();
        if (lst2.size() != max) {
            return false;
        }
        IntBitSet rest = new IntBitSet();
        rest.addRange(0, max - 1);
        for (int i = 0; i < max; ++i) {
            int[] prod2;
            int[] prod1 = lst1.get(i);
            int j = rest.first();
            while (j != -1 && !Grammar.equal(prod1, prod2 = lst2.get(j))) {
                j = rest.next(j);
            }
            if (j == -1) {
                return false;
            }
            rest.remove(j);
        }
        return true;
    }

    private static boolean equal(int[] prod1, int[] prod2) {
        if (prod1.length != prod2.length) {
            return false;
        }
        for (int ofs = 0; ofs < prod1.length; ++ofs) {
            if (prod1[ofs] == prod2[ofs] || prod1[ofs] == prod1[0] && prod2[ofs] == prod2[0]) continue;
            return false;
        }
        return true;
    }

    public void packSymbols(int first, int end) {
        int dest = first;
        for (int src = first; src < end; ++src) {
            boolean touched = this.renameSymbol(src, dest);
            if (!touched) continue;
            ++dest;
        }
    }

    public boolean renameSymbol(int prev, int next) {
        boolean touched = false;
        int maxProd = this.getProductionCount();
        for (int prod = 0; prod < maxProd; ++prod) {
            int[] ar = this.getProduction(prod);
            for (int ofs = 0; ofs < ar.length; ++ofs) {
                if (ar[ofs] != prev) continue;
                ar[ofs] = next;
                touched = true;
            }
        }
        return touched;
    }

    public void removeProductions(int symbol) {
        for (int prod = this.getProductionCount() - 1; prod >= 0; --prod) {
            if (this.getLeft(prod) != symbol) continue;
            this.removeProduction(prod);
        }
    }

    public void expandSymbol(int symbol) {
        int prod;
        int maxProd = this.getProductionCount();
        ArrayList<int[]> expandLst = new ArrayList<int[]>();
        for (prod = 0; prod < maxProd; ++prod) {
            if (this.getLeft(prod) != symbol) continue;
            expandLst.add(this.getProduction(prod));
        }
        int[][] expand = new int[expandLst.size()][];
        expandLst.toArray((T[])expand);
        for (prod = maxProd - 1; prod >= 0; --prod) {
            int ofs;
            int maxOfs = this.getLength(prod);
            boolean found = false;
            int nextCount = 1;
            for (ofs = 0; ofs < maxOfs; ++ofs) {
                if (this.getRight(prod, ofs) != symbol) continue;
                found = true;
                nextCount *= expand.length;
            }
            if (!found) continue;
            for (int i = 0; i < nextCount; ++i) {
                int count = i;
                IntArrayList next = new IntArrayList();
                next.add(this.getLeft(prod));
                for (ofs = 0; ofs < maxOfs; ++ofs) {
                    int right = this.getRight(prod, ofs);
                    if (right == symbol) {
                        int j = count % expand.length;
                        int maxOfs2 = expand[j].length;
                        for (int ofs2 = 1; ofs2 < maxOfs2; ++ofs2) {
                            next.add(expand[j][ofs2]);
                        }
                        count /= expand.length;
                        continue;
                    }
                    next.add(right);
                }
                if (count != 0) {
                    throw new RuntimeException();
                }
                this.addProduction(prod + 1, next.toArray());
            }
            this.removeProduction(prod);
        }
    }

    public void addNullable(IntBitSet result) {
        boolean modified;
        IntBitSet remaining = new IntBitSet();
        remaining.addRange(0, this.getProductionCount() - 1);
        do {
            modified = false;
            int prod = remaining.first();
            while (prod != -1) {
                if (result.contains(this.getLeft(prod))) {
                    remaining.remove(prod);
                } else {
                    int i;
                    int max = this.getLength(prod);
                    for (i = 0; i < max && result.contains(this.getRight(prod, i)); ++i) {
                    }
                    if (i == max) {
                        result.add(this.getLeft(prod));
                        modified = true;
                    }
                }
                prod = remaining.next(prod);
            }
        } while (modified);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int max = this.getProductionCount();
        for (int p = 0; p < max; ++p) {
            this.prodToString(buffer, p);
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public String prodToString(int prod) {
        StringBuilder builder = new StringBuilder();
        this.prodToString(builder, prod);
        return builder.toString();
    }

    public void prodToString(StringBuilder buffer, int prod) {
        buffer.append(this.symbolTable.getOrIndex(this.getLeft(prod)));
        buffer.append("\t::=");
        int max = this.getLength(prod);
        for (int i = 0; i < max; ++i) {
            buffer.append(' ');
            buffer.append(this.symbolTable.getOrIndex(this.getRight(prod, i)));
        }
    }
}

