/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.grammar;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.grammar.Symbol;
import net.oneandone.sushi.util.IntArrayList;

public class GrammarBase {
    private final List<int[]> productions = new ArrayList<int[]>();
    private Symbol[] symbols = null;

    public int getProductionCount() {
        return this.productions.size();
    }

    protected int[] getProduction(int prod) {
        return this.productions.get(prod);
    }

    protected void addProduction(int[] prod) {
        this.productions.add(prod);
        this.symbols = null;
    }

    protected void addProduction(int ofs, int[] prod) {
        this.productions.add(ofs, prod);
        this.symbols = null;
    }

    protected void removeProduction(int idx) {
        this.productions.remove(idx);
        this.symbols = null;
    }

    protected Symbol[] getSymbols() {
        if (this.symbols == null) {
            this.calcSymbols();
        }
        return this.symbols;
    }

    protected Symbol getSymbol(int sym) {
        return this.getSymbols()[sym];
    }

    private void calcSymbols() {
        int sym;
        int maxProd = this.productions.size();
        ArrayList<PreSymbol> pre = new ArrayList<PreSymbol>();
        for (int prod = 0; prod < maxProd; ++prod) {
            int[] current = this.getProduction(prod);
            for (int ofs = 0; ofs < current.length; ++ofs) {
                sym = current[ofs];
                while (pre.size() <= sym) {
                    pre.add(new PreSymbol());
                }
                PreSymbol ps = (PreSymbol)pre.get(sym);
                if (ofs == 0) {
                    ps.addAlternative(prod);
                    continue;
                }
                ps.addUser(prod, ofs - 1);
            }
        }
        this.symbols = new Symbol[pre.size()];
        for (sym = 0; sym < this.symbols.length; ++sym) {
            this.symbols[sym] = ((PreSymbol)pre.get(sym)).createSymbol();
        }
    }

    public static class PreSymbol {
        private final IntArrayList alternatives = new IntArrayList();
        private final IntArrayList users = new IntArrayList();
        private final List<IntArrayList> userOfs = new ArrayList<IntArrayList>();

        public void addAlternative(int prod) {
            this.alternatives.add(prod);
        }

        public void addUser(int prod, int ofs) {
            int i = this.users.indexOf(prod);
            if (i == -1) {
                i = this.users.size();
                this.users.add(prod);
                this.userOfs.add(new IntArrayList());
            }
            IntArrayList ofsArray = this.userOfs.get(i);
            ofsArray.add(ofs);
        }

        public Symbol createSymbol() {
            int[][] ofss = new int[this.users.size()][];
            for (int i = 0; i < ofss.length; ++i) {
                IntArrayList ofsArray = this.userOfs.get(i);
                ofss[i] = ofsArray.toArray();
            }
            return new Symbol(this.alternatives.toArray(), this.users.toArray(), ofss);
        }
    }
}

