/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.grammar;

import net.oneandone.mork.misc.StringArrayList;

public class Prefix {
    public static final int BASE = 512;
    private int index;
    private final long[] table;
    long data;

    public static long pack(int ... symbols) {
        long data = 0L;
        for (int symbol : symbols) {
            data = data * 512L + Prefix.pack(symbol);
        }
        return data;
    }

    public static long pack(int symbol) {
        if (symbol >= 511) {
            throw new IllegalArgumentException("" + symbol);
        }
        return symbol + 1;
    }

    public static int[] unpack(long data) {
        int[] result = new int[Prefix.size(data)];
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = (int)(data % 512L) - 1;
            data /= 512L;
        }
        return result;
    }

    Prefix(long[] table, int size) {
        this.table = table;
        this.index = 0;
    }

    public boolean step() {
        while (this.index < this.table.length) {
            if (this.table[this.index] != -1L) {
                this.data = this.table[this.index++];
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public int first() {
        long remaining = this.data;
        long next;
        while ((next = remaining / 512L) != 0L) {
            remaining = next;
        }
        return (int)remaining - 1;
    }

    public static long concat(long leftPrefix, long rightPrefix, int k) {
        int count;
        if (leftPrefix == 0L) {
            return rightPrefix;
        }
        if (rightPrefix == 0L) {
            return leftPrefix;
        }
        int leftSize = Prefix.size(leftPrefix);
        if (leftSize == k) {
            return leftPrefix;
        }
        int rightSize = Prefix.size(rightPrefix);
        long newData = leftPrefix;
        int newSize = Math.min(k, leftSize + rightSize);
        for (int i = count = newSize - leftSize; i > 0; --i) {
            newData *= 512L;
        }
        long tmp = rightPrefix;
        for (int i = rightSize - count; i > 0; --i) {
            tmp /= 512L;
        }
        return newData + tmp;
    }

    public int size() {
        return Prefix.size(this.data);
    }

    public static int size(long prefix) {
        int size = 0;
        while (prefix != 0L) {
            ++size;
            prefix /= 512L;
        }
        return size;
    }

    public int[] follows(int first) {
        int[] symbols = Prefix.unpack(this.data);
        if (symbols.length > 0 && symbols[0] == first) {
            int[] terminals = new int[symbols.length - 1];
            for (int i = 0; i < terminals.length; ++i) {
                terminals[i] = symbols[i + 1];
            }
            return terminals;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int symbol : Prefix.unpack(this.data)) {
            builder.append(' ');
            builder.append(symbol);
        }
        return builder.toString();
    }

    public void toString(StringArrayList symbolTable, StringBuilder result) {
        boolean first = true;
        for (int symbol : Prefix.unpack(this.data)) {
            if (first) {
                first = false;
            } else {
                result.append(' ');
            }
            result.append(symbolTable.getOrIndex(symbol));
        }
    }

    public static int hashFirst(long prefix, int length) {
        return (int)(prefix % (long)length);
    }

    public static int hashNext(long prefix, int previous, int length) {
        return (previous + 1 + (int)(prefix % (long)(length - 2))) % length;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Prefix) {
            return this.data == ((Prefix)obj).data;
        }
        return false;
    }
}

