/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.grammar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.oneandone.mork.grammar.Prefix;
import net.oneandone.mork.misc.StringArrayList;

public class PrefixSet {
    public static final int[] SIZES = new int[]{31, 73, 199, 421, 883, 1873, 3673, 7333, 14869, 29389, 57559, 116533, 234961, 489871, 999961};
    public static final long FREE = -1L;
    private long[] table;
    private int size;
    private int collisions;

    private int nextSize(int oldSize) {
        for (int i = 0; i < SIZES.length - 1; ++i) {
            if (oldSize != SIZES[i]) continue;
            return SIZES[i + 1];
        }
        throw new IllegalStateException();
    }

    public static PrefixSet one(int ... symbols) {
        PrefixSet result = new PrefixSet();
        result.addUnpacked(symbols);
        return result;
    }

    public PrefixSet() {
        this.table = new long[SIZES[0]];
        Arrays.fill(this.table, -1L);
    }

    public PrefixSet(PrefixSet orig) {
        this.table = new long[orig.table.length];
        this.size = orig.size;
        System.arraycopy(orig.table, 0, this.table, 0, this.table.length);
    }

    public Prefix iterator() {
        return new Prefix(this.table, this.size);
    }

    public double hashQuality() {
        return ((double)this.collisions + (double)this.size) / (double)this.size;
    }

    public double load() {
        return (double)this.size / (double)this.table.length;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean addUnpacked(int ... symbols) {
        return this.add(Prefix.pack(symbols));
    }

    public boolean add(long prefix) {
        int hash = Prefix.hashFirst(prefix, this.table.length);
        while (true) {
            long cmp;
            if ((cmp = this.table[hash]) == -1L) {
                this.table[hash] = prefix;
                if (this.size++ >= this.table.length * 3 / 4) {
                    long[] old = this.table;
                    this.size = 0;
                    this.collisions = 0;
                    this.table = new long[this.nextSize(old.length)];
                    Arrays.fill(this.table, -1L);
                    for (long p : old) {
                        if (p == -1L) continue;
                        this.add(p);
                    }
                }
                return true;
            }
            if (cmp == prefix) {
                return false;
            }
            ++this.collisions;
            hash = Prefix.hashNext(prefix, hash, this.table.length);
        }
    }

    public void addAll(PrefixSet set) {
        Prefix prefix = set.iterator();
        while (prefix.step()) {
            this.add(prefix.data);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PrefixSet) {
            PrefixSet set = (PrefixSet)o;
            if (set.size != this.size) {
                return false;
            }
            Prefix prefix = set.iterator();
            while (prefix.step()) {
                if (!this.notContains(prefix.data)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.size;
    }

    public String toString(StringArrayList symbolTable) {
        StringBuilder result = new StringBuilder();
        this.toString(symbolTable, result);
        return result.toString();
    }

    public void toString(StringArrayList symbolTable, StringBuilder result) {
        result.append('{');
        boolean first = true;
        Prefix prefix = this.iterator();
        while (prefix.step()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            prefix.toString(symbolTable, result);
        }
        result.append(" }");
    }

    public List<int[]> follows(int first) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        Prefix prefix = this.iterator();
        while (prefix.step()) {
            int[] terminals = prefix.follows(first);
            if (terminals == null) continue;
            result.add(terminals);
        }
        return result;
    }

    private boolean notContains(long prefix) {
        int hash = Prefix.hashFirst(prefix, this.table.length);
        long cmp;
        while ((cmp = this.table[hash]) != -1L) {
            if (cmp == prefix) {
                return false;
            }
            hash = Prefix.hashNext(prefix, hash, this.table.length);
        }
        return true;
    }
}

