/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.mapping;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.mapping.Definition;
import net.oneandone.mork.mapping.RelatedArgument;
import net.oneandone.mork.mapping.Transport;
import net.oneandone.mork.semantics.Ag;
import net.oneandone.mork.semantics.AgBuffer;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.Compare;
import net.oneandone.mork.semantics.Type;

public class Argument
implements Compare {
    private final Attribute attr;
    private final int modifier;
    private final AgBuffer copyBuffer;
    private final List<Definition> sources;

    public Argument(int modifier, AgBuffer buffer, List<Definition> sources) {
        this.modifier = modifier;
        this.attr = buffer.getStart();
        this.copyBuffer = buffer;
        this.sources = sources;
    }

    public void createTransport(Ag dest, Transport transport) {
        this.copyBuffer.createSemanticsBuffer(dest, transport);
    }

    public int getModifier() {
        return this.modifier;
    }

    public Attribute getAttribute() {
        return this.attr;
    }

    public int compare(Argument right) {
        return this.copyBuffer.compare(right.copyBuffer);
    }

    public static Argument merge(int symbol, List<Argument> arguments) {
        int max = arguments.size();
        if (max == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<AgBuffer> argBuffers = new ArrayList<AgBuffer>();
        Type mergedType = null;
        ArrayList<Definition> resultingSources = new ArrayList<Definition>();
        for (int i = 0; i < max; ++i) {
            Argument arg = arguments.get(i);
            resultingSources.addAll(arg.sources);
            if (arg == null) {
                throw new IllegalStateException();
            }
            argBuffers.add(arg.copyBuffer);
            mergedType = mergedType == null ? arg.attr.type : mergedType.alternate(arg.attr.type);
        }
        if (mergedType == null) {
            throw new IllegalStateException();
        }
        AgBuffer buffer = new AgBuffer((Attribute)null);
        Attribute start = buffer.merge(argBuffers, symbol, new Type(mergedType.type, 2));
        int card = buffer.calcCard(start);
        buffer = new AgBuffer((Attribute)null);
        start = buffer.merge(argBuffers, symbol, new Type(mergedType.type, card));
        buffer.setStart(start);
        return new Argument(0, buffer, resultingSources);
    }

    public static List<Argument> sortAndMergeArgs(Definition target, List<Argument> args) {
        Argument arg;
        int i;
        int max = args.size();
        ArrayList<Argument> seq = new ArrayList<Argument>();
        ArrayList<Argument> mergable = new ArrayList<Argument>();
        for (i = 0; i < max; ++i) {
            arg = args.get(i);
            if (arg.modifier == 1) {
                mergable.add(arg);
                continue;
            }
            seq.add(arg);
        }
        List<List<Argument>> sort = RelatedArgument.sort(mergable);
        max = sort.size();
        for (i = 0; i < max; ++i) {
            arg = Argument.merge(target.getAttribute().symbol, sort.get(i));
            seq.add(arg);
        }
        return seq;
    }

    public String toString() {
        return "{{arg start=" + this.attr + "\n" + this.copyBuffer.toString() + "}}";
    }

    public String getSourcesString() {
        StringBuilder result = new StringBuilder("(source attributes:");
        int max = this.sources.size();
        for (int i = 0; i < max; ++i) {
            result.append(' ');
            Definition def = this.sources.get(i);
            result.append(def.getName());
            result.append(" (type=");
            result.append(def.getAttribute().type.toString());
            result.append(')');
        }
        result.append(')');
        return result.toString();
    }
}

