/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.mapping;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.mapping.Argument;
import net.oneandone.mork.mapping.Definition;
import net.oneandone.mork.mapping.ToArray;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.reflect.Composition;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.reflect.Option;
import net.oneandone.mork.reflect.Selection;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.Type;

public class Conversion {
    public static final String ARGUMENT_TYPE_MISMATCH = "Argument type mismatch";
    public static final String AMBIGUOUS_CONSTRUCTOR_NAME = "Ambiguous constructor name";

    private static void throwIllegalCall(String kind, Selection selection, Definition def, List<Argument> args) throws GenericException {
        StringBuilder msg = new StringBuilder();
        msg.append("for attribute ");
        msg.append(def.getName());
        msg.append(":\n");
        msg.append("  constructors:\n");
        int max = selection.size();
        for (int i = 0; i < max; ++i) {
            msg.append("    " + selection.getFunction(i) + "\n");
        }
        msg.append("  arguments:\n");
        max = args.size();
        for (Argument arg : args) {
            msg.append("    " + arg.getAttribute().type + " " + arg.getSourcesString() + "\n");
        }
        throw new GenericException(kind, msg.toString());
    }

    public static Function find(Selection selection, Definition def, List<Argument> args, List<Attribute> outAttrs) throws GenericException {
        Function resultFn = null;
        ArrayList<Attribute> resultArgs = null;
        int max = selection.size();
        for (int i = 0; i < max; ++i) {
            List<Attribute> tmpInArgs = Conversion.getAttributes(args);
            ArrayList<Attribute> tmpOutArgs = new ArrayList<Attribute>();
            Function tmp = Conversion.arrange(selection.getFunction(i), tmpInArgs, tmpOutArgs);
            if (tmp == null) continue;
            if (resultFn != null) {
                Conversion.throwIllegalCall(AMBIGUOUS_CONSTRUCTOR_NAME, selection, def, args);
            }
            resultFn = tmp;
            resultArgs = tmpOutArgs;
        }
        if (resultFn == null) {
            Conversion.throwIllegalCall(ARGUMENT_TYPE_MISMATCH, selection, def, args);
        }
        outAttrs.addAll(resultArgs);
        return resultFn;
    }

    public static List<Attribute> getAttributes(List<Argument> args) {
        ArrayList<Attribute> lst = new ArrayList<Attribute>();
        for (Argument arg : args) {
            lst.add(arg.getAttribute());
        }
        return lst;
    }

    private static Function arrange(Function fn, List<Attribute> inArgs, List<Attribute> outArgs) {
        int max = fn.getParameterTypes().length;
        for (int i = 0; i < max; ++i) {
            if ((fn = Conversion.arrangeArg(fn, i, inArgs, outArgs)) != null) continue;
            return null;
        }
        if (inArgs.size() == 0) {
            return fn;
        }
        return null;
    }

    private static Function arrangeArg(Function fn, int idx, List<Attribute> inArgs, List<Attribute> outArgs) {
        Class<?> type = fn.getParameterTypes()[idx];
        Attribute attr = Conversion.removeAssignable(type, inArgs);
        if (attr == null) {
            return null;
        }
        outArgs.add(attr);
        if (type.isArray()) {
            return new Composition(fn, idx, new ToArray(type.getComponentType()));
        }
        if (List.class.isAssignableFrom(type)) {
            return fn;
        }
        if (attr.type.card == 1 || type.isPrimitive()) {
            fn = new Option(fn, idx);
        }
        return fn;
    }

    private static Attribute removeAssignable(Class<?> type, List<Attribute> inArgs) {
        int max = inArgs.size();
        for (int i = 0; i < max; ++i) {
            Attribute current = inArgs.get(i);
            if (!Conversion.isAssignableFrom(type, current.type)) continue;
            inArgs.remove(i);
            return current;
        }
        return null;
    }

    public static boolean hasFormalArgument(Selection sel, Type type) {
        if (sel != null) {
            int max = sel.size();
            for (int i = 0; i < max; ++i) {
                if (!Conversion.hasFormalArgument(sel.getFunction(i), type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasFormalArgument(Function fn, Type type) {
        Class<?>[] formalTypes = fn.getParameterTypes();
        for (int i = 0; i < formalTypes.length; ++i) {
            if (!Conversion.isAssignableFrom(formalTypes[i], type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Class<?> formalType, Type actual) {
        Class<?> compType;
        if (actual.card == 2) {
            if (List.class.isAssignableFrom(formalType)) {
                return true;
            }
            if (!formalType.isArray()) {
                return false;
            }
            if (formalType.isAssignableFrom(actual.type)) {
                return true;
            }
            compType = formalType.getComponentType();
        } else {
            compType = formalType;
        }
        if (compType.isAssignableFrom(actual.type)) {
            return true;
        }
        return compType.isPrimitive() && ClassRef.wrappedType(compType).isAssignableFrom(actual.type);
    }
}

