/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.mapping;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.mapping.Argument;
import net.oneandone.mork.mapping.Conversion;
import net.oneandone.mork.mapping.Internal;
import net.oneandone.mork.mapping.Transport;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.reflect.Selection;
import net.oneandone.mork.semantics.Ag;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.AttributeOccurrence;
import net.oneandone.mork.semantics.AttributionBuffer;
import net.oneandone.mork.semantics.Type;

public class Definition {
    public final String name;
    public final int symbol;
    private final boolean main;
    public final Object constructor;
    private Attribute attribute;
    private final List<Argument> isolated;
    private final List<Argument> mergeable;
    public static final String ARGUMENT_NOT_ASSIGNABLE = "Attribute A is visible to attribute B, but B has no formal argument A is assignable to.";

    public Definition(boolean main, Grammar grm, int symbol, String name, Object constructor) throws GenericException {
        this.main = main;
        this.name = name;
        this.symbol = symbol;
        this.constructor = constructor;
        this.isolated = new ArrayList<Argument>();
        this.mergeable = new ArrayList<Argument>();
        if (constructor instanceof Internal) {
            Internal var = (Internal)constructor;
            this.attribute = var.translate(symbol, grm);
        } else {
            Selection sel = (Selection)constructor;
            Type type = new Type(sel.calcResult(), 0);
            this.attribute = new Attribute(symbol, name, type);
        }
    }

    public void addArgument(Argument arg, Definition src) throws GenericException {
        Type type = arg.getAttribute().type;
        if (!Conversion.hasFormalArgument(this.getSelection(), type)) {
            throw new GenericException(ARGUMENT_NOT_ASSIGNABLE, "A=" + src.name + ", B=" + this.name + ", type of A=" + src.getAttribute().type.toString());
        }
        if (arg.getModifier() == 0) {
            this.isolated.add(arg);
        } else {
            this.mergeable.add(arg);
        }
    }

    public boolean isMain() {
        return this.main;
    }

    public String getName() {
        return this.name;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public Selection getSelection() {
        if (this.constructor instanceof Selection) {
            return (Selection)this.constructor;
        }
        return null;
    }

    public void translate(Ag semantics, Transport transport, Grammar grammar) throws GenericException {
        Selection selection = this.getSelection();
        if (selection == null) {
            ((Internal)this.constructor).declare(this.attribute, semantics);
            return;
        }
        ArrayList<Argument> args = new ArrayList<Argument>();
        this.translateArguments(transport, semantics, args);
        ArrayList<Attribute> argAttrs = new ArrayList<Attribute>();
        Function fn = Conversion.find(selection, this, args, argAttrs);
        if (grammar.isTerminal(this.attribute.symbol)) {
            int maxUser = grammar.getUserCount(this.attribute.symbol);
            for (int user = 0; user < maxUser; ++user) {
                int prod = grammar.getUser(this.attribute.symbol, user);
                int maxAlt = grammar.getUserOfsCount(this.attribute.symbol, user);
                for (int alt = 0; alt < maxAlt; ++alt) {
                    semantics.add(Definition.createAB(this.attribute, prod, grammar.getUserOfs(this.attribute.symbol, user, alt), fn, argAttrs));
                }
            }
        } else {
            int maxAlt = grammar.getAlternativeCount(this.attribute.symbol);
            for (int alt = 0; alt < maxAlt; ++alt) {
                semantics.add(Definition.createAB(this.attribute, grammar.getAlternative(this.attribute.symbol, alt), -1, fn, argAttrs));
            }
        }
    }

    private static AttributionBuffer createAB(Attribute result, int prod, int ofs, Function fn, List<Attribute> args) {
        AttributionBuffer ab = new AttributionBuffer(prod, fn, new AttributeOccurrence(result, ofs));
        for (Attribute a : args) {
            ab.add(new AttributeOccurrence(a, ofs));
        }
        return ab;
    }

    private void translateArguments(Transport transport, Ag semantics, List<Argument> result) throws GenericException {
        List<Argument> sorted = Argument.sortAndMergeArgs(this, this.mergeable);
        for (Argument arg : this.isolated) {
            arg.createTransport(semantics, transport);
            result.add(arg);
        }
        for (Argument arg : sorted) {
            arg.createTransport(semantics, transport);
            result.add(arg);
        }
    }

    public String toString() {
        return "Definition " + this.name + " " + this.attribute;
    }
}

