/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.mapping;

import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.reflect.Constructor;
import net.oneandone.mork.reflect.Field;
import net.oneandone.mork.reflect.Method;
import net.oneandone.mork.reflect.Selection;

public class Import {
    public final String name;
    public final Class target;
    public static final String NO_CLASS = "no such class";
    public static final String NO_CONSTRUCTOR = "no public constructor";
    public static final String NO_MEMBER = "no such method or field";

    public Import(String name, Class target) {
        this.name = name;
        this.target = target;
    }

    public static Import create(String packageName, String className, String name) throws GenericException {
        String fullName;
        Class<?> cls;
        if (name == null) {
            name = className;
        }
        if ((cls = new ClassRef(fullName = packageName + "." + className).lookup()) == null) {
            throw new GenericException(NO_CLASS, fullName);
        }
        return new Import(name, cls);
    }

    public String toString() {
        return "reference " + this.name + ":" + this.target;
    }

    public Selection lookup(String member) throws GenericException {
        Selection selection = Method.forName(this.target, member);
        Field f = Field.forName(this.target, member);
        if (f != null) {
            selection = selection.add(new Selection(f));
        }
        if (selection.isEmpty()) {
            throw new GenericException(NO_MEMBER, this.name + "." + member);
        }
        return selection;
    }

    public Selection getConstructors() throws GenericException {
        Selection selection = Constructor.forClass(this.target);
        if (selection.isEmpty()) {
            throw new GenericException(NO_CONSTRUCTOR, this.name);
        }
        return selection;
    }
}

