/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.mapping;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.oneandone.mork.mapping.ErrorHandler;
import net.oneandone.mork.mapping.PrintWriterErrorHandler;
import net.oneandone.mork.parser.Parser;
import net.oneandone.mork.scanner.Position;
import net.oneandone.mork.semantics.Oag;
import net.oneandone.sushi.fs.Node;

public class Mapper
implements Serializable {
    private final String name;
    private Parser parser;
    private Oag oag;
    private PrintWriter logParsing;
    private PrintWriter logAttribution;
    private Object environment;
    private ErrorHandler errorHandler;

    public Mapper(String name) {
        this(name, null, null);
    }

    public Mapper(String name, ErrorHandler errorHandler) {
        this(name, null, null, errorHandler);
    }

    public Mapper(String name, Parser parser, Oag oag) {
        this(name, parser, oag, new PrintWriterErrorHandler(new PrintWriter(System.err, true)));
    }

    public Mapper(String name, Parser parser, Oag oag, ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.parser = parser;
        this.oag = oag;
        this.errorHandler = errorHandler;
        this.logParsing = null;
        this.logAttribution = null;
    }

    public Mapper newInstance() {
        Mapper mapper = new Mapper(this.name, this.parser.newInstance(), this.oag.newInstance());
        mapper.setLogging(this.logParsing, this.logAttribution);
        return mapper;
    }

    public void load() {
        Object[] tables;
        Method m;
        Class<?> c;
        if (this.isLoaded()) {
            return;
        }
        ClassLoader loader = Mapper.class.getClassLoader();
        try {
            c = loader.loadClass(this.name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(this.name + ": cannot load class: " + e.getMessage(), e);
        }
        try {
            m = c.getMethod("load", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        try {
            tables = (Object[])m.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException().getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.parser = (Parser)tables[0];
        this.oag = (Oag)tables[1];
    }

    public boolean isLoaded() {
        return this.parser != null;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException();
        }
        this.errorHandler = errorHandler;
    }

    public void setEnvironment(Object environment) {
        this.environment = environment;
    }

    public void setLogging(PrintWriter logParsing, PrintWriter logAttribution) {
        this.logParsing = logParsing;
        this.logAttribution = logAttribution;
    }

    public Parser getParser() {
        this.load();
        return this.parser;
    }

    public Oag getSemantics() {
        this.load();
        return this.oag;
    }

    public Object[] run(String fileName) throws IOException {
        return this.run(new File(fileName));
    }

    public Object[] run(Node node) throws IOException {
        return this.run(node.toString(), (Reader)node.newReader());
    }

    public Object[] run(File file) throws IOException {
        return this.run(file.toURI().toURL().toString(), (Reader)new FileReader(file));
    }

    public Object[] run(String context, Reader src) throws IOException {
        return this.run(new Position(context), src);
    }

    public Object[] run(Position position, Reader src) throws IOException {
        this.load();
        this.oag.setEnvironment(this.environment);
        this.oag.setLogging(this.logAttribution);
        this.parser.setErrorHandler(this.errorHandler);
        net.oneandone.mork.semantics.Node node = (net.oneandone.mork.semantics.Node)this.parser.run(position, src, this.oag, this.logParsing);
        src.close();
        this.errorHandler.close();
        if (node == null) {
            throw new IllegalStateException("errorHandler.close expected to throw an exception");
        }
        return node.attrs;
    }

    public void repl(String prompt, String end) {
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            Object[] result;
            String line;
            System.out.print(prompt);
            try {
                line = input.readLine();
            }
            catch (IOException e) {
                System.out.println("io error: " + e.toString());
                return;
            }
            if (line == null) {
                return;
            }
            if (line.equals(end)) {
                return;
            }
            try {
                result = this.run("", (Reader)new StringReader(line));
            }
            catch (IOException e) {
                throw new IllegalStateException("unexpected io exception from StringReader", e);
            }
            if (result == null || result.length <= 0) continue;
            System.out.println(result[0]);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Parser:\n");
        buf.append(this.parser.toString());
        buf.append("Semantics:\n");
        buf.append(this.oag.toString());
        return buf.toString();
    }
}

