/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.mapping;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.compiler.Syntax;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.mapping.Argument;
import net.oneandone.mork.mapping.Definition;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.semantics.AgBuffer;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.Occurrence;
import net.oneandone.mork.semantics.Pusher;
import net.oneandone.mork.semantics.Type;
import net.oneandone.sushi.util.IntBitSet;

public class Path {
    public static final int DOWN = 0;
    public static final int DOWNS = 1;
    public static final int UP = 2;
    public static final int UPS = 3;
    public static final int ISOLATED = 0;
    public static final int MERGEABLE = 1;
    private final Grammar grammar;
    private final Definition source;
    private final List<Definition> targets;
    private final int[] moves;
    private final IntBitSet[] stoppers;
    private final int modifier;
    private final List<AgBuffer>[] copyBuffers;

    public static void translate(Syntax syntax, Definition source, int move, IntBitSet stopper, List<Definition> targets, int modifier) throws GenericException {
        Path.translate(syntax, modifier, source, targets, new int[]{move}, new IntBitSet[]{new IntBitSet(stopper)});
    }

    public static void translate(Syntax syntax, Definition source, Definition target) throws GenericException {
        ArrayList<Definition> targets = new ArrayList<Definition>();
        targets.add(target);
        IntBitSet stopper = new IntBitSet();
        stopper.add(target.getAttribute().symbol);
        Path.translate(syntax, 0, source, targets, new int[0], new IntBitSet[]{stopper});
    }

    public static void translate(Syntax syntax, Definition source, int[] moves, int[] symbols, Definition target, int modifier) throws GenericException {
        int i;
        if (moves.length - 1 != symbols.length) {
            throw new IllegalArgumentException();
        }
        IntBitSet[] stoppers = new IntBitSet[moves.length];
        ArrayList<Definition> targets = new ArrayList<Definition>();
        targets.add(target);
        for (i = 0; i < symbols.length; ++i) {
            stoppers[i] = new IntBitSet();
            stoppers[i].add(symbols[i]);
        }
        stoppers[i] = new IntBitSet();
        stoppers[i].add(target.getAttribute().symbol);
        Path.translate(syntax, modifier, source, targets, moves, stoppers);
    }

    private static void translate(Syntax syntax, int modifier, Definition source, List<Definition> targets, int[] moves, IntBitSet[] stoppers) throws GenericException {
        Path path = new Path(syntax.getGrammar(), modifier, source, targets, moves, stoppers);
        int count = path.translate();
        if (count == 0 && source.getAttribute().symbol != syntax.getGrammar().getStart()) {
            throw new GenericException("dead-end path for attribute " + source.getName());
        }
    }

    private Path(Grammar grammar, int modifier, Definition source, List<Definition> targets, int[] moves, IntBitSet[] stoppers) {
        this.grammar = grammar;
        this.modifier = modifier;
        this.source = source;
        this.targets = targets;
        this.moves = moves;
        this.stoppers = stoppers;
        this.copyBuffers = new List[moves.length];
    }

    private int translate() throws GenericException {
        int step;
        List<AgBuffer> buffers = new ArrayList<AgBuffer>();
        buffers.add(new AgBuffer(this.source.getAttribute()));
        for (step = 0; step < this.moves.length; ++step) {
            this.translateStep(step, buffers);
            buffers = this.copyBuffers[step];
        }
        int max = buffers.size();
        for (step = 0; step < max; ++step) {
            ArrayList<Definition> sources = new ArrayList<Definition>();
            sources.add(this.source);
            Argument arg = new Argument(this.modifier, buffers.get(step), sources);
            Definition target = this.lookupTarget(arg.getAttribute().symbol);
            target.addArgument(arg, this.source);
        }
        return max;
    }

    private void translateStep(int step, List<AgBuffer> initialBuffers) {
        IntBitSet targetSymbols = step == this.moves.length - 1 ? Path.getTargetSymbols(this.targets) : this.stoppers[step];
        this.copyBuffers[step] = new ArrayList<AgBuffer>();
        int max = initialBuffers.size();
        for (int i = 0; i < max; ++i) {
            AgBuffer buffer = initialBuffers.get(i);
            this.prefixedTransport(step, buffer, this.stoppers[step], targetSymbols);
        }
    }

    private void prefixedTransport(int step, AgBuffer prefixBuffer, IntBitSet border, IntBitSet targetSymbols) {
        Attribute attr = prefixBuffer.getStart();
        List<AgBuffer> resultBuffers = this.copyBuffers[step];
        int ofs = resultBuffers.size();
        Path.transport(this.grammar, attr, this.moves[step], border, targetSymbols, resultBuffers);
        int max = resultBuffers.size();
        for (int i = ofs; i < max; ++i) {
            Attribute oldAttr = resultBuffers.get(i).getStart();
            AgBuffer tmp = new AgBuffer((Attribute)null);
            tmp.append(prefixBuffer);
            tmp.append(resultBuffers.get(i));
            AgBuffer buffer = new AgBuffer((Attribute)null);
            Attribute newAttr = buffer.cloneAttributes(tmp, oldAttr.type, oldAttr);
            buffer.setStart(newAttr);
            resultBuffers.set(i, buffer);
        }
    }

    private static IntBitSet getTargetSymbols(List<Definition> defs) {
        IntBitSet result = new IntBitSet();
        for (Definition def : defs) {
            result.add(def.getAttribute().symbol);
        }
        return result;
    }

    private Definition lookupTarget(int symbol) {
        for (Definition def : this.targets) {
            if (def.getAttribute().symbol != symbol) continue;
            return def;
        }
        return null;
    }

    private static void transport(Grammar grammar, Attribute seed, int move, IntBitSet rawBorder, IntBitSet targetSymbols, List<AgBuffer> resultBuffers) {
        boolean down;
        IntBitSet border;
        if (move == 0 || move == 2) {
            border = new IntBitSet();
            grammar.getSymbols(border);
        } else {
            border = rawBorder;
        }
        boolean bl = down = move == 0 || move == 1;
        if (down && !border.contains(seed.symbol)) {
            border.add(seed.symbol);
        }
        AgBuffer commulated = Pusher.run(down, seed, border, grammar);
        List<Attribute> attrs = commulated.getTransportAttributes();
        int max = attrs.size();
        for (int i = 0; i < max; ++i) {
            int card;
            Attribute dest = attrs.get(i);
            if (dest == seed || !targetSymbols.contains(dest.symbol)) continue;
            AgBuffer tmp = commulated.createReduced(dest);
            Occurrence occ = null;
            if (down) {
                card = tmp.isDownOptional() ? 1 : 0;
                card = Type.cardCard(card, seed.type.card);
            } else {
                occ = tmp.calcOccurrence(dest);
                card = Type.cardCard(occ.card(), seed.type.card);
                if (seed.type.card == 2 || occ.max == Integer.MAX_VALUE) {
                    occ = null;
                }
            }
            if (occ == null) {
                AgBuffer buffer = new AgBuffer((Attribute)null);
                Attribute attr = buffer.cloneAttributes(tmp, new Type(seed.type.type, card), dest);
                buffer.setStart(attr);
                resultBuffers.add(buffer);
                continue;
            }
            Path.createSplitted(tmp, seed.type.type, occ, dest, resultBuffers);
        }
    }

    private static void createSplitted(AgBuffer orig, Class<?> cls, Occurrence occ, Attribute origDest, List<AgBuffer> resultBuffers) {
        orig.calcOccurrences();
        for (int seq = 0; seq < occ.max; ++seq) {
            AgBuffer tmp = new AgBuffer((Attribute)null);
            Attribute dest = orig.createSequence(origDest, seq, tmp);
            Type type = seq < occ.min ? new Type(cls, 0) : new Type(cls, 1);
            AgBuffer buffer = new AgBuffer((Attribute)null);
            Attribute attr = buffer.cloneAttributes(tmp, type, dest);
            buffer.setStart(attr);
            resultBuffers.add(buffer);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (IntBitSet stopper : this.stoppers) {
            builder.append(" ");
            builder.append(stopper);
        }
        return builder.toString();
    }
}

