/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.mapping;

import java.io.IOException;
import java.io.PrintWriter;
import net.oneandone.mork.mapping.ErrorHandler;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.scanner.Position;
import net.oneandone.sushi.util.IntBitSet;

public class PrintWriterErrorHandler
implements ErrorHandler {
    private final PrintWriter dest;
    private boolean failed;

    public PrintWriterErrorHandler(PrintWriter dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.dest = dest;
        this.failed = false;
    }

    protected void report(String pos, String message) {
        this.dest.println(pos + ": " + message);
        this.failed = true;
    }

    @Override
    public void lexicalError(Position pos) {
        this.report(pos.toString(), "illegal token");
    }

    @Override
    public void syntaxError(Position pos, IntBitSet shiftable) {
        this.report(pos.toString(), "syntax error");
    }

    @Override
    public void semanticError(Position pos, Exception e) {
        this.report(pos.toString(), e.getMessage());
    }

    public void error(String pos, GenericException e) {
        this.report(pos, e.getMessage());
    }

    public void error(String pos, String message) {
        this.report(pos, message);
    }

    @Override
    public void close() throws IOException {
        if (this.failed) {
            throw new IOException("mapping failed");
        }
    }
}

