/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.mapping;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.mapping.Argument;
import net.oneandone.mork.semantics.Compare;

public class RelatedArgument
implements Compare {
    private final Argument arg;
    private final List<RelatedArgument> nexts;

    public static List<List<Argument>> sort(List<Argument> args) {
        ArrayList<List<Argument>> result = new ArrayList<List<Argument>>();
        List<RelatedArgument> remaining = RelatedArgument.createRelatedArgs(args);
        int max;
        while ((max = remaining.size()) != 0) {
            ArrayList<RelatedArgument> heads = new ArrayList<RelatedArgument>();
            for (int i = 0; i < max; ++i) {
                RelatedArgument.addHead(heads, remaining.get(i));
            }
            remaining.clear();
            result.add(RelatedArgument.separate(heads, remaining));
        }
        return result;
    }

    private static List<RelatedArgument> createRelatedArgs(List<Argument> args) {
        ArrayList<RelatedArgument> related = new ArrayList<RelatedArgument>();
        int max = args.size();
        for (int i = 0; i < max; ++i) {
            related.add(new RelatedArgument(args.get(i)));
        }
        return related;
    }

    private static void addHead(List<RelatedArgument> heads, RelatedArgument left) {
        int max = heads.size();
        boolean foundLT = false;
        boolean foundGT = false;
        block4: for (int i = max - 1; i >= 0; --i) {
            RelatedArgument right = heads.get(i);
            switch (left.arg.compare(right.arg)) {
                case 2: {
                    left.nexts.add(right);
                    heads.remove(i);
                    foundLT = true;
                    continue block4;
                }
                case 4: {
                    if (foundGT) continue block4;
                    right.nexts.add(left);
                    foundGT = true;
                    continue block4;
                }
            }
        }
        if (foundGT && foundLT) {
            throw new IllegalStateException();
        }
        if (!foundGT) {
            heads.add(left);
        }
    }

    private static List<Argument> separate(List<RelatedArgument> heads, List<RelatedArgument> tails) {
        ArrayList<Argument> merge = new ArrayList<Argument>();
        for (RelatedArgument head : heads) {
            merge.add(head.arg);
            tails.addAll(head.nexts);
        }
        return merge;
    }

    public RelatedArgument(Argument arg) {
        this.arg = arg;
        this.nexts = new ArrayList<RelatedArgument>();
    }
}

