/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.mapping;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.List;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.compiler.Util;
import net.oneandone.mork.reflect.Arrays;
import net.oneandone.mork.reflect.Function;

public class ToArray
extends Function
implements Bytecodes {
    private Class componentType;

    public ToArray(Class componentType) {
        this.componentType = componentType;
    }

    @Override
    public String getName() {
        return "To" + this.componentType.getName() + "Array";
    }

    public Class getReturnType() {
        return Arrays.getArrayClass(this.componentType);
    }

    public Class[] getParameterTypes() {
        return new Class[]{List.class};
    }

    public Class[] getExceptionTypes() {
        return NO_CLASSES;
    }

    @Override
    public Object invoke(Object[] vals) {
        List lst = (List)vals[0];
        int max = lst.size();
        Object result = Array.newInstance(this.componentType, max);
        for (int i = 0; i < max; ++i) {
            Array.set(result, i, lst.get(i));
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ClassRef.write(out, this.componentType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, NoSuchMethodException {
        this.componentType = ClassRef.read(in);
    }

    @Override
    public void translate(Code dest) {
        ClassRef listRef = new ClassRef(List.class);
        ClassRef type = new ClassRef(this.componentType);
        int lstVar = dest.allocate(listRef);
        int maxVar = dest.allocate(ClassRef.INT);
        int iVar = dest.allocate(ClassRef.INT);
        int arrayVar = dest.allocate(ClassRef.OBJECT);
        dest.emit(192, listRef);
        dest.emit(89);
        dest.emit(58, lstVar);
        dest.emit(185, MethodRef.ifc(listRef, ClassRef.INT, "size"));
        dest.emit(89);
        dest.emit(54, maxVar);
        type.emitArrayNew(dest);
        dest.emit(58, arrayVar);
        dest.emit(18, 0);
        dest.emit(54, iVar);
        int startLabel = dest.currentLabel();
        int endLabel = dest.declareLabel();
        dest.emit(21, iVar);
        dest.emit(21, maxVar);
        dest.emit(162, endLabel);
        dest.emit(25, arrayVar);
        dest.emit(21, iVar);
        dest.emit(25, lstVar);
        dest.emit(21, iVar);
        dest.emit(185, MethodRef.ifc(listRef, ClassRef.OBJECT, "get", ClassRef.INT));
        Util.unwrap(this.componentType, dest);
        if (!type.isPrimitive()) {
            dest.emit(192, type);
        }
        type.emitArrayStore(dest);
        dest.emit(132, iVar, 1);
        dest.emit(167, startLabel);
        dest.defineLabel(endLabel);
        dest.emit(25, arrayVar);
    }
}

