/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.mapping;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.reflect.Composition;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.reflect.Method;
import net.oneandone.mork.reflect.Option;
import net.oneandone.mork.semantics.Attribute;

public class Transport {
    private final Function fnCopy;
    private final Function fnCreateOption = Transport.get("createOption");
    private final Function fnCreateSequence = Transport.get("createSequence");
    private final Function fnCreateSequenceValue = Transport.get("createSequenceValue");
    private final Function fnCreateSequenceOption = Transport.get("createSequenceOption");
    private final Function fnSequenceAndValue = Transport.get("sequenceAndValue");
    private final Function fnSequenceAndOption = Transport.get("sequenceAndOption");
    private final Function fnSequenceAndSequence = Transport.get("sequenceAndSequence");

    public Transport() {
        this.fnCopy = Transport.get("copy");
    }

    private static Function get(String name) {
        Function fn = Method.forName(Transport.class, name).getFunction();
        if (fn == null) {
            throw new RuntimeException("not found: " + name);
        }
        return fn;
    }

    public Function getTransportFn(List<Attribute> src, int destCard) {
        switch (destCard) {
            case 1: {
                switch (src.size()) {
                    case 0: {
                        return this.fnCreateOption;
                    }
                    case 1: {
                        return this.fnCopy;
                    }
                }
                String msg = "no optional transport for this number of arguments: " + src.size();
                throw new RuntimeException(msg);
            }
            case 0: {
                if (src.size() != 1) {
                    String msg = "no value transport for this number of arguments: " + src.size();
                    throw new RuntimeException(msg);
                }
                return this.fnCopy;
            }
            case 2: {
                int max = src.size();
                if (max == 0) {
                    return this.fnCreateSequence;
                }
                int srcCard = src.get((int)0).type.card;
                Function tmp = this.getInitialSequence(srcCard);
                for (int i = 1; i < max; ++i) {
                    srcCard = src.get((int)i).type.card;
                    tmp = Composition.create(this.getSequenceAnd(srcCard), 0, tmp);
                }
                return tmp;
            }
        }
        throw new RuntimeException();
    }

    private Function getInitialSequence(int cardinality) {
        switch (cardinality) {
            case 0: {
                return this.fnCreateSequenceValue;
            }
            case 1: {
                return this.fnCreateSequenceOption;
            }
            case 2: {
                return this.fnCopy;
            }
        }
        throw new RuntimeException();
    }

    private Function getSequenceAnd(int card) {
        switch (card) {
            case 0: {
                return this.fnSequenceAndValue;
            }
            case 1: {
                return this.fnSequenceAndOption;
            }
            case 2: {
                return this.fnSequenceAndSequence;
            }
        }
        throw new RuntimeException();
    }

    public static Object createOption() {
        return Option.TAG;
    }

    public static Object createSequence() {
        return new ArrayList();
    }

    public static Object createSequenceOption(Object obj) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (obj != Option.TAG) {
            result.add(obj);
        }
        return result;
    }

    public static Object createSequenceValue(Object obj) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(obj);
        return result;
    }

    public static Object copy(Object obj) {
        return obj;
    }

    public static Object sequenceAndOption(Object list, Object obj) {
        if (obj != Option.TAG) {
            ((List)list).add(obj);
        }
        return list;
    }

    public static Object sequenceAndValue(Object list, Object obj) {
        ((List)list).add(obj);
        return list;
    }

    public static Object sequenceAndSequence(Object list, Object operand) {
        ((List)list).addAll((List)operand);
        return list;
    }
}

