/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.misc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class StringArrayList
implements Serializable {
    private static final int GROW = 256;
    private String[] data;
    private int size;

    public StringArrayList(String[] data) {
        this(data.length, data);
    }

    public StringArrayList(int size, String[] data) {
        this.size = size;
        this.data = data;
    }

    public StringArrayList() {
        this.data = new String[256];
        this.size = 0;
    }

    public StringArrayList(StringArrayList orig) {
        this.data = new String[orig.data.length];
        this.size = orig.size;
        System.arraycopy(orig.data, 0, this.data, 0, this.size);
    }

    public void add(String str) {
        if (this.size == this.data.length) {
            String[] tmp = new String[this.data.length + 256];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
        this.data[this.size] = str;
        ++this.size;
    }

    public void addAll(StringArrayList vec) {
        int max = vec.size();
        for (int i = 0; i < max; ++i) {
            this.add(vec.get(i));
        }
    }

    public int indexOf(String str) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.data[i].equals(str)) continue;
            return i;
        }
        return -1;
    }

    public String get(int idx) {
        return this.data[idx];
    }

    public String getOrIndex(int idx) {
        String result;
        if (idx >= 0 && idx < this.data.length && (result = this.data[idx]) != null) {
            return result;
        }
        return "<" + idx + ">";
    }

    public void set(int idx, String str) {
        this.data[idx] = str;
    }

    public void remove(int idx) {
        --this.size;
        for (int i = idx; i < this.size; ++i) {
            this.data[i] = this.data[i + 1];
        }
    }

    public int size() {
        return this.size;
    }

    public List<String> toList() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.size; ++i) {
            result.add(this.data[i]);
        }
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("StringArrayList {\n");
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == null) continue;
            buf.append(" " + i + "\t= " + this.data[i] + "\n");
        }
        buf.append("}\n");
        return buf.toString();
    }
}

