/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.parser;

import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.parser.ParserTable;
import net.oneandone.mork.pda.State;

public class Conflict {
    private final String type;
    private final int stateId;
    private final State state;
    private final int symbol;
    private final int[] actions;

    public Conflict(String type, int stateId, State state, int symbol, int ... actions) {
        this.type = type;
        this.stateId = stateId;
        this.state = state;
        this.symbol = symbol;
        this.actions = actions;
    }

    public String toString(Grammar grammar) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type + " conflict in state " + this.stateId + " on symbol ");
        builder.append(grammar.getSymbolTable().getOrIndex(this.symbol));
        builder.append(": ");
        boolean first = true;
        for (int action : this.actions) {
            if (first) {
                first = false;
            } else {
                builder.append(" vs ");
            }
            builder.append(ParserTable.actionToString(action, grammar));
        }
        builder.append("\n").append(this.state.toShortString(grammar));
        return builder.toString();
    }
}

