/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.parser;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import net.oneandone.mork.compiler.ConflictResolver;
import net.oneandone.mork.mapping.ErrorHandler;
import net.oneandone.mork.parser.ParserTable;
import net.oneandone.mork.parser.TreeBuilder;
import net.oneandone.mork.scanner.Position;
import net.oneandone.mork.scanner.Scanner;
import net.oneandone.mork.scanner.ScannerFactory;
import net.oneandone.mork.semantics.SemanticError;

public class Parser {
    private final ParserTable table;
    private final ConflictResolver[] resolvers;
    private final ScannerFactory scannerFactory;
    private ErrorHandler errorHandler;
    private static final int STACK_SIZE = 10240;
    private int top;
    private final int[] states;
    private final Object[] nodes;
    public static final char SPECIAL = '\u0000';
    public static final char SHIFT = '\u0001';
    public static final char REDUCE = '\u0002';
    public static final char SKIP = '\u0003';
    public static final char SPECIAL_ERROR = '\u0000';
    public static final char SPECIAL_ACCEPT = '\u0001';
    public static final char SPECIAL_CONFLICT = '\u0002';

    public Parser(ParserTable table, ConflictResolver[] resolvers, ScannerFactory scannerFactory) {
        this.table = table;
        this.resolvers = resolvers;
        this.scannerFactory = scannerFactory;
        this.errorHandler = null;
        this.states = new int[10240];
        this.nodes = new Object[10240];
        this.top = -1;
    }

    public ParserTable getTable() {
        return this.table;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Parser newInstance() {
        return new Parser(this.table, this.resolvers, this.scannerFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object run(Position position, Reader src, TreeBuilder treeBuilder, PrintWriter verbose) throws IOException {
        try {
            Scanner scanner = this.scannerFactory.newInstance(position, src);
            treeBuilder.open(scanner, this);
            try {
                int state = this.table.getStartState();
                this.push(state, null);
                block24: while (true) {
                    int terminal = scanner.next(this.table.getMode(state));
                    switch (terminal) {
                        case -2: {
                            Position pos = new Position();
                            scanner.getPosition(pos);
                            this.errorHandler.lexicalError(pos);
                            Object var13_14 = null;
                            return var13_14;
                        }
                        case -1: {
                            terminal = this.table.getEofSymbol();
                            break;
                        }
                    }
                    block25: while (true) {
                        int value = this.table.lookup(state, terminal);
                        while (ParserTable.getAction(value) == 0) {
                            int operand = ParserTable.getOperand(value);
                            switch (operand) {
                                case 1: {
                                    Object object = this.pop();
                                    return object;
                                }
                                case 0: {
                                    Position pos = new Position();
                                    scanner.getPosition(pos);
                                    this.errorHandler.syntaxError(pos, this.table.getShifts(state));
                                    Object var13_16 = null;
                                    return var13_16;
                                }
                            }
                            if ((operand & 3) != 2) {
                                throw new IllegalStateException();
                            }
                            value = this.resolvers[operand >> 2].run(scanner, this.table.getMode(state), this.table.getEofSymbol());
                        }
                        switch (ParserTable.getAction(value)) {
                            case 1: {
                                if (verbose != null) {
                                    verbose.print(this.stateStr());
                                    verbose.println("shift " + ParserTable.getOperand(value));
                                }
                                state = ParserTable.getOperand(value);
                                this.push(state, treeBuilder.createTerminal(terminal));
                                continue block24;
                            }
                            case 2: {
                                Object node;
                                int production = ParserTable.getOperand(value);
                                if (verbose != null) {
                                    verbose.print(this.stateStr());
                                    verbose.println("reduce " + production);
                                }
                                try {
                                    node = treeBuilder.createNonterminal(production);
                                }
                                catch (SemanticError e) {
                                    this.errorHandler.semanticError(e.position, e.exception);
                                    Object var14_19 = null;
                                    this.top = -1;
                                    return var14_19;
                                }
                                state = this.table.lookupShift(this.getState(), production);
                                this.push(state, node);
                                continue block25;
                            }
                            case 3: {
                                if (verbose == null) continue block24;
                                verbose.print(this.stateStr());
                                verbose.println("skip " + terminal);
                                continue block24;
                            }
                        }
                        break;
                    }
                    break;
                }
                throw new RuntimeException();
            }
            finally {
                this.top = -1;
            }
        }
        catch (IOException e) {
            throw new IOException(position.toString() + ": io error: " + e.getMessage(), e);
        }
    }

    private String stateStr() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = 0; i <= this.top; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            builder.append(this.states[i]);
        }
        builder.append("] ");
        return builder.toString();
    }

    public int getLeft(int production) {
        return this.table.getLeft(production);
    }

    public int getState() {
        return this.states[this.top];
    }

    public Object pop() {
        return this.nodes[this.top--];
    }

    public void push(int state, Object node) {
        ++this.top;
        this.states[this.top] = state;
        this.nodes[this.top] = node;
    }
}

