/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.parser;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.compiler.ConflictHandler;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.pda.State;
import net.oneandone.sushi.util.IntBitSet;

public class ParserTable
implements Serializable {
    private static final int ACTION_BITS = 2;
    private static final int MAX_OPERAND = 49151;
    private static final int MASK = 3;
    private final char startState;
    private final int symbolCount;
    private final int eofSymbol;
    private final char[] values;
    private final int[] lengths;
    private final int[] lefts;
    private char[] modes;
    public static final int NOT_SET = ParserTable.createValue(0, 0);
    private static final int COUNT_MARK = 7;
    private static final int MAX_UTF8_LENGTH = 21845;

    public ParserTable(char startState, int symbolCount, int eofSymbol, char[] values, int[] lengths, int[] lefts, char[] modes) {
        this.startState = startState;
        this.symbolCount = symbolCount;
        this.eofSymbol = eofSymbol;
        this.values = values;
        this.lengths = lengths;
        this.lefts = lefts;
        this.modes = modes;
    }

    public ParserTable(char startState, int symbolCount, int eofSymbol, int stateCount, String[] packedValues, int[] lengths, int[] lefts, char[] modes) {
        this(startState, symbolCount, eofSymbol, new char[stateCount * symbolCount], lengths, lefts, modes);
        this.unpackValues(packedValues);
    }

    public ParserTable(int startState, int stateCount, int symbolCount, int eofSymbol, Grammar grm, char[] modes) throws GenericException {
        int i;
        if (stateCount >= 49151) {
            throw new GenericException("too may states");
        }
        this.startState = (char)startState;
        this.symbolCount = symbolCount;
        this.eofSymbol = eofSymbol;
        this.modes = modes;
        this.values = new char[stateCount * symbolCount];
        for (i = 0; i < this.values.length; ++i) {
            this.values[i] = ParserTable.createValue(0, 0);
        }
        int max = grm.getSymbolCount();
        if (max >= 49151) {
            throw new GenericException("too may symbols");
        }
        max = grm.getProductionCount();
        this.lengths = new int[max];
        this.lefts = new int[max];
        for (i = 0; i < max; ++i) {
            this.lengths[i] = grm.getLength(i);
            this.lefts[i] = grm.getLeft(i);
        }
    }

    public int getEofSymbol() {
        return this.eofSymbol;
    }

    public int getValueCount() {
        return this.values.length;
    }

    public void setModes(char[] modes) {
        this.modes = modes;
    }

    public void addShift(int state, int sym, int nextState) {
        int idx = state * this.symbolCount + sym;
        if (this.values[idx] != NOT_SET) {
            throw new IllegalStateException();
        }
        this.values[idx] = ParserTable.createValue(1, nextState);
    }

    public void addReduce(int stateId, State state, int terminal, int prod, ConflictHandler handler) {
        int idx = stateId * this.symbolCount + terminal;
        char old = this.values[idx];
        char value = ParserTable.createValue(2, prod);
        if (old == NOT_SET) {
            this.values[idx] = value;
        } else if (value != old) {
            this.values[idx] = handler.resolve(stateId, state, terminal, old, value);
        }
    }

    public void addAccept(int state, int eof) {
        this.values[state * this.symbolCount + eof] = ParserTable.createValue(0, 1);
    }

    public void addWhitespace(IntBitSet whites) {
        int stateCount = this.getStateCount();
        int sym = whites.first();
        while (sym != -1) {
            for (int state = 0; state < stateCount; ++state) {
                int idx = state * this.symbolCount + sym;
                if (this.values[idx] != NOT_SET) {
                    throw new IllegalStateException();
                }
                this.values[idx] = this.createValue(3);
            }
            sym = whites.next(sym);
        }
    }

    private char createValue(int action) {
        return ParserTable.createValue(action, 0);
    }

    public static char createValue(int action, int operand) {
        return (char)(action | operand << 2);
    }

    public String[] packValues() {
        StringBuilder difs = new StringBuilder();
        StringBuilder vals = new StringBuilder();
        int prev = 0;
        for (int i = 0; i < this.values.length; ++i) {
            char v = this.values[i];
            if (v == ParserTable.createValue(0, 0)) continue;
            int count = this.sameValues(i);
            difs.append((char)(i - prev));
            if (count <= 2) {
                vals.append(this.values[i]);
            } else {
                vals.append('\u0007');
                difs.append((char)count);
                vals.append(this.values[i]);
                i += count - 1;
            }
            prev = i;
        }
        return this.packValue(difs, vals);
    }

    public String[] packValue(StringBuilder difs, StringBuilder vals) {
        if (difs.length() != vals.length()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> lst = new ArrayList<String>();
        ParserTable.split(difs, 21845, lst);
        ParserTable.split(vals, 21845, lst);
        String[] array = new String[lst.size()];
        lst.toArray(array);
        return array;
    }

    private static void split(StringBuilder str, int chunkLength, List<String> result) {
        int max = str.length();
        for (int i = 0; i < max; i += chunkLength) {
            result.add(str.substring(i, Math.min(max, i + chunkLength)));
        }
    }

    private void unpackValues(String[] packed) {
        int idx = 0;
        boolean marked = false;
        int chunkCount = packed.length / 2;
        for (int chunk = 0; chunk < chunkCount; ++chunk) {
            String difs = packed[chunk];
            String vals = packed[chunk + chunkCount];
            int max = difs.length();
            for (int i = 0; i < max; ++i) {
                char ch = vals.charAt(i);
                if (marked) {
                    int end = idx + difs.charAt(i);
                    while (idx < end) {
                        this.values[idx] = ch;
                        ++idx;
                    }
                    --idx;
                    marked = false;
                    continue;
                }
                if (ch == '\u0007') {
                    idx += difs.charAt(i);
                    marked = true;
                    continue;
                }
                this.values[idx += difs.charAt((int)i)] = ch;
            }
        }
    }

    private int sameValues(int ofs) {
        char cmp = this.values[ofs];
        for (int i = ofs + 1; i < this.values.length; ++i) {
            if (this.values[i] == cmp) continue;
            return i - ofs;
        }
        return this.values.length - ofs;
    }

    public int getSymbolCount() {
        return this.symbolCount;
    }

    public int getStateCount() {
        return this.values.length / this.symbolCount;
    }

    public int getStartState() {
        return this.startState;
    }

    public int getProductionCount() {
        return this.lefts.length;
    }

    public int getLeft(int prod) {
        return this.lefts[prod];
    }

    public int getLength(int prod) {
        return this.lengths[prod];
    }

    public static int getAction(int value) {
        return value & 3;
    }

    public static int getOperand(int value) {
        return value >>> 2;
    }

    public int lookup(int state, int symbol) {
        return this.values[state * this.symbolCount + symbol];
    }

    public int lookupShift(int state, int production) {
        return this.values[state * this.symbolCount + this.lefts[production]] >>> 2;
    }

    public char getMode(int state) {
        return this.modes[state];
    }

    public void print(PrintWriter dest) {
        for (int i = 0; i < this.values.length; ++i) {
            if (i % 30 == 0) {
                dest.println();
            }
            dest.print(" " + this.values[i]);
        }
    }

    public IntBitSet getShifts(int state) {
        int symbolCount = this.getSymbolCount();
        IntBitSet result = new IntBitSet();
        for (int i = 0; i < symbolCount; ++i) {
            int value = this.lookup(state, i);
            int action = ParserTable.getAction(value);
            if (action != 1 && action != 2) continue;
            result.add(i);
        }
        return result;
    }

    public int[] getLengths() {
        int[] result = new int[this.getProductionCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getLength(i);
        }
        return result;
    }

    public int[] getLefts() {
        int[] result = new int[this.getProductionCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getLeft(i);
        }
        return result;
    }

    public String toString(Grammar grammar) {
        int symbol;
        int stateCount = this.getStateCount();
        int symbolCount = this.getSymbolCount();
        StringBuilder result = new StringBuilder();
        result.append('\t');
        for (symbol = 0; symbol < symbolCount; ++symbol) {
            result.append(grammar.getSymbolTable().getOrIndex(symbol));
            result.append('\t');
        }
        result.append("\n\n");
        for (int state = 0; state < stateCount; ++state) {
            result.append(state);
            result.append('\t');
            for (symbol = 0; symbol < symbolCount; ++symbol) {
                int value = this.lookup(state, symbol);
                result.append(ParserTable.actionToString(value, grammar)).append('\t');
            }
            result.append('\n');
        }
        return result.toString();
    }

    public static String actionToString(int value, Grammar grammar) {
        switch (ParserTable.getAction(value)) {
            case 1: {
                return "S " + ParserTable.getOperand(value);
            }
            case 2: {
                return "R " + grammar.prodToString(ParserTable.getOperand(value));
            }
            case 0: {
                if (ParserTable.getOperand(value) == 1) {
                    return "A";
                }
                return " ";
            }
        }
        throw new RuntimeException("unknown action: " + ParserTable.getAction(value));
    }
}

