/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.pda;

import java.util.List;
import java.util.Map;
import net.oneandone.mork.grammar.Concat;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.grammar.PrefixSet;
import net.oneandone.mork.misc.StringArrayList;

public class Item
implements Comparable<Item> {
    public final int core;
    public final PrefixSet lookahead;

    public static Item create(Grammar grammar, int production, PrefixSet lookahead) {
        return new Item(production << 8 | grammar.getLength(production), lookahead);
    }

    private Item(int core, PrefixSet lookahead) {
        this.core = core;
        this.lookahead = lookahead;
    }

    public int getProduction() {
        return this.core >> 8;
    }

    public int getRemaining() {
        return (byte)this.core;
    }

    public int getShift(Grammar grammar) {
        int remaining = this.getRemaining();
        if (remaining == 0) {
            return -1;
        }
        int production = this.getProduction();
        return grammar.getRight(production, grammar.getLength(production) - remaining);
    }

    public boolean isReduce() {
        return this.getRemaining() == 0;
    }

    public Item createShifted() {
        if (this.isReduce()) {
            return null;
        }
        return new Item(this.core - 1, this.lookahead);
    }

    public void expanded(Grammar grammar, Map<Integer, PrefixSet> firsts, List<Item> result, int k) {
        int remaining = this.getRemaining();
        if (remaining > 0) {
            int production = this.getProduction();
            int dot = grammar.getLength(production) - remaining;
            int symbol = grammar.getRight(production, dot);
            int maxAlt = grammar.getAlternativeCount(symbol);
            for (int alt = 0; alt < maxAlt; ++alt) {
                PrefixSet first = Item.first(grammar, firsts, production, dot + 1, this.lookahead, k);
                Item item = Item.create(grammar, grammar.getAlternative(symbol, alt), first);
                if (result.contains(item)) continue;
                result.add(item);
            }
        }
    }

    private static PrefixSet first(Grammar grammar, Map<Integer, PrefixSet> firsts, int production, int dot, PrefixSet lookahead, int k) {
        int len = grammar.getLength(production);
        if (len == dot) {
            return new PrefixSet(lookahead);
        }
        Concat concat = new Concat(k);
        for (int ofs = dot; ofs < len; ++ofs) {
            int symbol = grammar.getRight(production, ofs);
            if (!concat.with(firsts.get(symbol))) continue;
            return concat.result();
        }
        concat.with(lookahead);
        return concat.result();
    }

    public int hashCode() {
        return this.core;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Item) {
            Item cmp = (Item)obj;
            return this.core == cmp.core && this.lookahead.equals(cmp.lookahead);
        }
        return false;
    }

    @Override
    public int compareTo(Item obj) {
        Item item = obj;
        if (this.core < item.core) {
            return -1;
        }
        if (this.core > item.core) {
            return 1;
        }
        return 0;
    }

    public String toString(Grammar grammar, boolean suppressLookahead) {
        int ofs;
        int production = this.getProduction();
        int dot = grammar.getLength(production) - this.getRemaining();
        StringArrayList symbolTable = grammar.getSymbolTable();
        StringBuilder result = new StringBuilder();
        result.append(symbolTable.getOrIndex(grammar.getLeft(production)));
        result.append("\t::=");
        int len = grammar.getLength(production);
        for (ofs = 0; ofs < len; ++ofs) {
            result.append(' ');
            if (ofs == dot) {
                result.append(". ");
            }
            result.append(symbolTable.getOrIndex(grammar.getRight(production, ofs)));
        }
        if (ofs == dot && !suppressLookahead) {
            result.append(" . \t");
            this.lookahead.toString(symbolTable, result);
        }
        result.append('\n');
        return result.toString();
    }
}

