/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.pda;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.oneandone.mork.compiler.ConflictHandler;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.grammar.PrefixSet;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.parser.ParserTable;
import net.oneandone.mork.pda.Item;
import net.oneandone.mork.pda.PDABuilder;
import net.oneandone.mork.pda.Queue;
import net.oneandone.mork.pda.Shift;
import net.oneandone.mork.pda.State;

public class PDA
implements PDABuilder {
    private final Grammar grammar;
    private final HashMap<State, Integer> states;
    private final State start;

    public static PDA create(Grammar grammar, final Map<Integer, PrefixSet> firsts, final int k, int threadCount) {
        Thread[] threads = new Thread[threadCount];
        final Queue todo = new Queue(threads.length);
        State state = State.forStartSymbol(grammar, grammar.getSymbolCount());
        state.closure(grammar, firsts, k);
        final PDA pda = new PDA(grammar, state);
        todo.put(state);
        final ArrayList exceptions = new ArrayList();
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread("pda-builder-" + i){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            State state = todo.take();
                            state.gotos(pda, firsts, todo, k);
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (Throwable e) {
                        List list = exceptions;
                        synchronized (list) {
                            exceptions.add(e);
                        }
                        return;
                    }
                }
            };
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new IllegalStateException("thread exceptions: " + exceptions.size(), (Throwable)exceptions.get(0));
        }
        int end = pda.add(new State());
        pda.start.shifts.add(new Shift(grammar.getStart(), end));
        return pda;
    }

    public PDA(Grammar grammar, State start) {
        this.grammar = grammar;
        this.states = new LinkedHashMap<State, Integer>();
        this.start = start;
        this.add(start);
    }

    private Iterable<State> states() {
        return this.states.keySet();
    }

    public int add(State state) {
        int id = this.states.size();
        this.states.put(state, id);
        return id;
    }

    @Override
    public Grammar getGrammar() {
        return this.grammar;
    }

    @Override
    public synchronized int addIfNew(State state) {
        Integer existing = this.states.get(state);
        return existing == null ? -this.add(state) : existing;
    }

    @Override
    public int size() {
        return this.states.size();
    }

    public int getEofSymbol() {
        return this.grammar.getSymbolCount();
    }

    public ParserTable createTable(int lastSymbol, ConflictHandler handler) throws GenericException {
        int eof = this.getEofSymbol();
        ParserTable result = new ParserTable(0, this.size(), lastSymbol + 1, eof, this.grammar, null);
        for (Map.Entry<State, Integer> entry : this.states.entrySet()) {
            entry.getKey().addActions(entry.getValue(), result, handler);
        }
        int end = this.start.lookupShift((int)this.grammar.getStart()).end;
        result.addAccept(end, eof);
        return result;
    }

    public void print(PrintWriter dest) {
        for (Map.Entry<State, Integer> entry : this.states.entrySet()) {
            dest.println(entry.getKey().toString(entry.getValue(), this.grammar));
        }
    }

    public void statistics(PrintWriter output) {
        int itemsCount = 0;
        int itemsMin = Integer.MAX_VALUE;
        int itemsMax = Integer.MIN_VALUE;
        int lookaheadMax = Integer.MIN_VALUE;
        int lookaheadMin = Integer.MAX_VALUE;
        int lookaheadSizes = 0;
        double hqSum = 0.0;
        double hqMax = Double.MIN_VALUE;
        double hqMin = Double.MAX_VALUE;
        double loadSum = 0.0;
        double loadMax = Double.MIN_VALUE;
        double loadMin = Double.MAX_VALUE;
        for (State state : this.states()) {
            int size = state.items.size();
            itemsCount += size;
            itemsMin = Math.min(itemsMin, size);
            itemsMax = Math.max(itemsMax, size);
            for (Item item : state.items) {
                size = item.lookahead.size();
                lookaheadSizes += size;
                lookaheadMin = Math.min(lookaheadMin, size);
                lookaheadMax = Math.max(lookaheadMax, size);
                double q = item.lookahead.hashQuality();
                hqSum += q;
                hqMax = Math.max(q, hqMax);
                hqMin = Math.min(q, hqMin);
                q = item.lookahead.load();
                loadSum += q;
                loadMax = Math.max(q, loadMax);
                loadMin = Math.min(q, loadMin);
            }
        }
        output.println("parser generation statistics");
        output.println("  states: " + this.states.size());
        output.println("  items avg: " + itemsCount / this.states.size() + ", min: " + itemsMin + ", max: " + itemsMax + ")");
        output.println("  lookahead avg: " + lookaheadSizes / itemsCount + ", min: " + lookaheadMin + ", max: " + lookaheadMax);
        output.println("  hash quality avg: " + hqSum / (double)itemsCount + ", min: " + hqMin + ", max: " + hqMax);
        output.println("  hash load avg: " + loadSum / (double)itemsCount + ", min: " + loadMin + ", max: " + loadMax);
        output.println("  heap size: " + Runtime.getRuntime().totalMemory());
        output.println("  heap used: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
    }
}

