/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.pda;

import net.oneandone.mork.pda.State;

public class Queue {
    private final int threadCount;
    private Element states;
    private final Object monitor;
    private int waitingTakes;
    private boolean terminate;

    public Queue(int threadCount) throws IllegalArgumentException {
        this.threadCount = threadCount;
        this.states = null;
        this.monitor = new Object();
        this.waitingTakes = 0;
        this.terminate = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(State x) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.terminate) {
                throw new IllegalStateException();
            }
            this.states = new Element(x, this.states);
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State take() throws InterruptedException {
        State result;
        Object object = this.monitor;
        synchronized (object) {
            if (this.terminate) {
                throw new IllegalStateException();
            }
            while (this.states == null) {
                ++this.waitingTakes;
                if (this.waitingTakes == this.threadCount) {
                    this.terminate = true;
                    this.monitor.notifyAll();
                    throw new InterruptedException();
                }
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException ie) {
                    throw new IllegalStateException(ie);
                }
                finally {
                    --this.waitingTakes;
                }
                if (!this.terminate) continue;
                throw new InterruptedException();
            }
            result = this.states.state;
            this.states = this.states.next;
        }
        return result;
    }

    private static class Element {
        public final State state;
        public final Element next;

        public Element(State state, Element next) {
            this.state = state;
            this.next = next;
        }
    }
}

