/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.pda;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.oneandone.mork.compiler.ConflictHandler;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.grammar.Prefix;
import net.oneandone.mork.grammar.PrefixSet;
import net.oneandone.mork.parser.ParserTable;
import net.oneandone.mork.pda.Item;
import net.oneandone.mork.pda.PDABuilder;
import net.oneandone.mork.pda.Queue;
import net.oneandone.mork.pda.Shift;
import net.oneandone.sushi.util.IntBitSet;

public class State {
    public final List<Shift> shifts;
    public final List<Item> items = new ArrayList<Item>();

    public static State forStartSymbol(Grammar grammar, int eof) {
        State state = new State();
        int symbol = grammar.getStart();
        int max = grammar.getAlternativeCount(symbol);
        for (int alt = 0; alt < max; ++alt) {
            state.items.add(Item.create(grammar, grammar.getAlternative(symbol, alt), PrefixSet.one(eof)));
        }
        return state;
    }

    public State() {
        this.shifts = new ArrayList<Shift>();
    }

    public void closure(Grammar grammar, Map<Integer, PrefixSet> firsts, int k) {
        Item item;
        int i;
        for (i = 0; i < this.items.size(); ++i) {
            item = this.items.get(i);
            item.expanded(grammar, firsts, this.items, k);
        }
        for (i = 0; i < this.items.size(); ++i) {
            item = this.items.get(i);
            for (int j = i + 1; j < this.items.size(); ++j) {
                Item cmp = this.items.get(j);
                if (item.core != cmp.core) continue;
                item.lookahead.addAll(cmp.lookahead);
                this.items.remove(j);
                --j;
            }
        }
        Collections.sort(this.items);
    }

    public void gotos(PDABuilder pda, Map<Integer, PrefixSet> firsts, Queue created, int k) {
        Grammar grammar = pda.getGrammar();
        IntBitSet shiftSymbols = this.getShiftSymbols(grammar);
        int symbol = shiftSymbols.first();
        while (symbol != -1) {
            State state = new State();
            for (Item item : this.items) {
                Item shifted;
                if (item.getShift(grammar) != symbol || (shifted = item.createShifted()) == null) continue;
                state.items.add(shifted);
            }
            state.closure(grammar, firsts, k);
            int target = pda.addIfNew(state);
            if (target < 0) {
                created.put(state);
                target = -target;
            }
            this.shifts.add(new Shift(symbol, target));
            symbol = shiftSymbols.next(symbol);
        }
    }

    private IntBitSet getShiftSymbols(Grammar grammar) {
        IntBitSet result = new IntBitSet();
        for (Item item : this.items) {
            int symbol = item.getShift(grammar);
            if (symbol == -1) continue;
            result.add(symbol);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof State) {
            State state = (State)obj;
            return this.items.equals(state.items);
        }
        return false;
    }

    public int hashCode() {
        return this.items.size() == 0 ? 0 : this.items.get(0).hashCode() * 256 + this.items.get(this.items.size() - 1).hashCode();
    }

    public void addActions(int id, ParserTable result, ConflictHandler handler) {
        for (Shift sh : this.shifts) {
            result.addShift(id, sh.symbol, sh.end);
        }
        for (Item item : this.items) {
            if (!item.isReduce()) continue;
            Prefix prefix = item.lookahead.iterator();
            while (prefix.step()) {
                if (prefix.size() < 1) {
                    throw new IllegalStateException();
                }
                result.addReduce(id, this, prefix.first(), item.getProduction(), handler);
            }
        }
    }

    public Shift lookupShift(int symbol) {
        for (Shift shift : this.shifts) {
            if (shift.symbol != symbol) continue;
            return shift;
        }
        return null;
    }

    public Item getReduceItem(int production) {
        for (Item item : this.items) {
            if (!item.isReduce() || item.getProduction() != production) continue;
            return item;
        }
        throw new IllegalStateException();
    }

    public String toString(int id, Grammar grammar) {
        StringBuilder result = new StringBuilder();
        result.append("\n------------------------------\n");
        result.append("[state " + id + "]\n");
        for (Item item : this.items) {
            result.append(item.toString(grammar, false));
        }
        result.append('\n');
        for (Shift sh : this.shifts) {
            result.append(sh.toString(grammar.getSymbolTable()));
        }
        result.append('\n');
        return result.toString();
    }

    public String toShortString(Grammar grammar) {
        StringBuilder result = new StringBuilder();
        for (Item item : this.items) {
            result.append(item.toString(grammar, true));
        }
        result.append('\n');
        for (Shift sh : this.shifts) {
            result.append(sh.toString(grammar.getSymbolTable()));
        }
        result.append('\n');
        return result.toString();
    }
}

