/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.reflect;

import java.lang.reflect.InvocationTargetException;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.reflect.Arrays;
import net.oneandone.mork.reflect.Function;

public class Composition
extends Function {
    private final Function base;
    private final Function para;
    private final int idx;
    private final int baseParaCount;
    private final int paraParaCount;

    public Composition(Function baseInit, int idxInit, Function paraInit) {
        this.base = baseInit;
        this.idx = idxInit;
        this.para = paraInit;
        this.baseParaCount = this.base.getParameterTypes().length;
        this.paraParaCount = this.para.getParameterTypes().length;
    }

    public static Composition create(Function baseInit, int idxInit, Function paraInit) {
        Class<?>[] tmp = baseInit.getParameterTypes();
        if (idxInit >= tmp.length) {
            return null;
        }
        if (!tmp[idxInit].isAssignableFrom(paraInit.getReturnType())) {
            return null;
        }
        return new Composition(baseInit, idxInit, paraInit);
    }

    @Override
    public String getName() {
        return this.base.getName() + this.idx + this.para.getName();
    }

    public Class getReturnType() {
        return this.base.getReturnType();
    }

    public Class[] getParameterTypes() {
        Class<?>[] a = this.base.getParameterTypes();
        Class<?>[] b = this.para.getParameterTypes();
        Class[] result = new Class[a.length - 1 + b.length];
        System.arraycopy(a, 0, result, 0, this.idx);
        System.arraycopy(b, 0, result, this.idx, b.length);
        System.arraycopy(a, this.idx + 1, result, this.idx + b.length, a.length - (this.idx + 1));
        return result;
    }

    public Class[] getExceptionTypes() {
        return (Class[])Arrays.append(Class.class, this.base.getExceptionTypes(), this.para.getExceptionTypes());
    }

    @Override
    public Object invoke(Object[] allVals) throws InvocationTargetException {
        Object[] vals = new Object[this.paraParaCount];
        System.arraycopy(allVals, this.idx, vals, 0, vals.length);
        Object tmp = this.para.invoke(vals);
        vals = new Object[this.baseParaCount];
        System.arraycopy(allVals, 0, vals, 0, this.idx);
        vals[this.idx] = tmp;
        System.arraycopy(allVals, this.idx + this.paraParaCount, vals, this.idx + 1, vals.length - (this.idx + 1));
        return this.base.invoke(vals);
    }

    @Override
    public void translate(Code dest) {
        int i;
        Class[] tmp = this.getParameterTypes();
        int ofs = this.idx + this.paraParaCount;
        int max = tmp.length - ofs;
        int[] vars = new int[max];
        ClassRef[] types = new ClassRef[max];
        for (i = max - 1; i >= 0; --i) {
            int var;
            ClassRef type;
            types[i] = type = new ClassRef(tmp[i + ofs]);
            vars[i] = var = dest.allocate(type);
            type.emitStore(dest, var);
        }
        this.para.translate(dest);
        for (i = 0; i < max; ++i) {
            types[i].emitLoad(dest, vars[i]);
        }
        this.base.translate(dest);
    }
}

