/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.reflect.Method;
import net.oneandone.mork.reflect.Selection;

public class Constructor
extends Function
implements Bytecodes {
    private java.lang.reflect.Constructor constr;

    public static Selection forName(String name) {
        Class<?> cl = ClassRef.classFind(name);
        if (cl == null) {
            return new Selection();
        }
        return Constructor.forClass(cl);
    }

    public static Selection forClass(Class cl) {
        ArrayList<Constructor> lst = new ArrayList<Constructor>();
        java.lang.reflect.Constructor<?>[] constrs = cl.getConstructors();
        for (int i = 0; i < constrs.length; ++i) {
            Constructor fn = Constructor.create(constrs[i]);
            if (fn == null) continue;
            lst.add(fn);
        }
        return new Selection(lst);
    }

    public Constructor(java.lang.reflect.Constructor constrInit) {
        int modif = constrInit.getModifiers();
        if (Modifier.isAbstract(modif) || !Modifier.isPublic(modif)) {
            throw new IllegalArgumentException();
        }
        this.constr = constrInit;
    }

    public static Constructor create(java.lang.reflect.Constructor constr) {
        try {
            return new Constructor(constr);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.constr.getName();
    }

    public Class getReturnType() {
        return this.constr.getDeclaringClass();
    }

    public Class[] getParameterTypes() {
        return this.constr.getParameterTypes();
    }

    public Class[] getExceptionTypes() {
        return this.constr.getExceptionTypes();
    }

    @Override
    public Object invoke(Object[] vals) throws InvocationTargetException {
        try {
            return this.constr.newInstance(vals);
        }
        catch (IllegalArgumentException | InvocationTargetException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("can't access constructor");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("can't instantiate");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Constructor.write(out, this.constr);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, NoSuchMethodException {
        this.constr = Constructor.read(in);
    }

    public static void write(ObjectOutput out, java.lang.reflect.Constructor constr) throws IOException {
        if (constr == null) {
            ClassRef.write(out, null);
        } else {
            Class cl = constr.getDeclaringClass();
            ClassRef.write(out, cl);
            ClassRef.writeClasses(out, constr.getParameterTypes());
        }
    }

    public static java.lang.reflect.Constructor read(ObjectInput in) throws ClassNotFoundException, IOException, NoSuchMethodException {
        Class<?> cl = ClassRef.read(in);
        if (cl == null) {
            return null;
        }
        Class<?>[] types = ClassRef.readClasses(in);
        return cl.getConstructor(types);
    }

    @Override
    public void translate(Code dest) {
        int i;
        Class[] tmp = this.getParameterTypes();
        int max = tmp.length;
        int[] vars = new int[max];
        ClassRef[] types = new ClassRef[max];
        for (i = max - 1; i >= 0; --i) {
            int var;
            ClassRef type;
            types[i] = type = new ClassRef(tmp[i]);
            vars[i] = var = dest.allocate(type);
            type.emitStore(dest, var);
        }
        dest.emit(187, new ClassRef(this.constr.getDeclaringClass()));
        dest.emit(89);
        for (i = 0; i < max; ++i) {
            types[i].emitLoad(dest, vars[i]);
            if (!Method.isCastType(tmp[i])) continue;
            dest.emit(192, types[i]);
        }
        dest.emit(183, new MethodRef(this.constr));
    }
}

