/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Modifier;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.FieldRef;
import net.oneandone.mork.reflect.Function;

public class Field
extends Function
implements Bytecodes {
    private java.lang.reflect.Field field;

    public static Field forName(String name) {
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        Class<?> cl = ClassRef.classFind(name.substring(0, idx));
        if (cl == null) {
            return null;
        }
        return Field.forName(cl, name.substring(idx + 1));
    }

    public static Field forName(Class cl, String name) {
        java.lang.reflect.Field result;
        try {
            result = cl.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        return Field.create(result);
    }

    public Field(java.lang.reflect.Field fieldInit) {
        this.field = fieldInit;
        this.field.setAccessible(true);
    }

    public static Field create(java.lang.reflect.Field fieldInit) {
        try {
            return new Field(fieldInit);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    public Class getReturnType() {
        return this.field.getType();
    }

    public Class[] getParameterTypes() {
        if (this.isStatic()) {
            return NO_CLASSES;
        }
        return new Class[]{this.field.getDeclaringClass()};
    }

    public Class[] getExceptionTypes() {
        return NO_CLASSES;
    }

    @Override
    public Object invoke(Object[] vals) {
        try {
            if (this.isStatic()) {
                return this.field.get(null);
            }
            return this.field.get(vals[0]);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("can't access field");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Field.write(out, this.field);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, NoSuchFieldException, IOException {
        this.field = Field.read(in);
    }

    public static void write(ObjectOutput out, java.lang.reflect.Field field) throws IOException {
        if (field == null) {
            ClassRef.write(out, null);
        } else {
            ClassRef.write(out, field.getDeclaringClass());
            out.writeUTF(field.getName());
        }
    }

    public static java.lang.reflect.Field read(ObjectInput in) throws ClassNotFoundException, NoSuchFieldException, IOException {
        Class<?> cl = ClassRef.read(in);
        if (cl == null) {
            return null;
        }
        String name = in.readUTF();
        return cl.getDeclaredField(name);
    }

    @Override
    public void translate(Code dest) {
        if (this.isStatic()) {
            dest.emit(178, new FieldRef(this.field));
        } else {
            ClassRef type = new ClassRef(this.getParameterTypes()[0]);
            if (!type.isPrimitive()) {
                dest.emit(192, type);
            }
            dest.emit(180, new FieldRef(this.field));
        }
    }
}

