/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.MethodRef;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.reflect.Selection;

public class Method
extends Function
implements Bytecodes {
    private java.lang.reflect.Method meth;

    public static Selection forName(String name) {
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return new Selection();
        }
        Class<?> cl = ClassRef.classFind(name.substring(0, idx));
        if (cl == null) {
            return new Selection();
        }
        return Method.forName(cl, name.substring(idx + 1));
    }

    public static Selection forName(Class cl, String name) {
        java.lang.reflect.Method[] all = cl.getDeclaredMethods();
        ArrayList<Method> lst = new ArrayList<Method>();
        for (int i = 0; i < all.length; ++i) {
            Method fn;
            if (!name.equals(all[i].getName()) || (fn = Method.create(all[i])) == null) continue;
            lst.add(fn);
        }
        return new Selection(lst);
    }

    public Method(java.lang.reflect.Method methInit) {
        int modif = methInit.getModifiers();
        if (Modifier.isAbstract(modif) || !Modifier.isPublic(modif)) {
            throw new IllegalArgumentException();
        }
        this.meth = methInit;
    }

    public static Method create(java.lang.reflect.Method meth) {
        try {
            return new Method(meth);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.meth.getModifiers());
    }

    public java.lang.reflect.Method getRaw() {
        return this.meth;
    }

    @Override
    public String getName() {
        return this.meth.getName();
    }

    public Class getReturnType() {
        return this.meth.getReturnType();
    }

    public Class[] getParameterTypes() {
        if (this.isStatic()) {
            return this.meth.getParameterTypes();
        }
        Class<?>[] tmp = this.meth.getParameterTypes();
        Class[] result = new Class[1 + tmp.length];
        result[0] = this.meth.getDeclaringClass();
        System.arraycopy(tmp, 0, result, 1, tmp.length);
        return result;
    }

    public Class[] getExceptionTypes() {
        return this.meth.getExceptionTypes();
    }

    @Override
    public Object invoke(Object[] vals) throws InvocationTargetException {
        try {
            if (this.isStatic()) {
                return this.meth.invoke(null, vals);
            }
            if (vals.length == 0) {
                throw new IllegalArgumentException("invalid arguments");
            }
            Object[] tmp = new Object[vals.length - 1];
            for (int i = 1; i < vals.length; ++i) {
                tmp[i - 1] = vals[i];
            }
            return this.meth.invoke(vals[0], tmp);
        }
        catch (IllegalArgumentException | InvocationTargetException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("can't access method");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Method.write(out, this.meth);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, NoSuchMethodException, IOException {
        this.meth = Method.read(in);
    }

    public static void write(ObjectOutput out, java.lang.reflect.Method meth) throws IOException {
        if (meth == null) {
            ClassRef.write(out, null);
        } else {
            Class<?> cl = meth.getDeclaringClass();
            ClassRef.write(out, cl);
            out.writeUTF(meth.getName());
            ClassRef.writeClasses(out, meth.getParameterTypes());
        }
    }

    public static java.lang.reflect.Method read(ObjectInput in) throws ClassNotFoundException, NoSuchMethodException, IOException {
        Class<?> cl = ClassRef.read(in);
        if (cl == null) {
            return null;
        }
        String name = in.readUTF();
        Class<?>[] types = ClassRef.readClasses(in);
        return cl.getMethod(name, types);
    }

    @Override
    public void translate(Code dest) {
        Class[] tmp = this.getParameterTypes();
        int first = Method.firstCastArguments(tmp);
        if (first != -1) {
            if (tmp.length == 1) {
                Method.castSingleArgument(tmp, dest);
            } else {
                Method.castArguments(first, tmp, dest);
            }
        }
        if (this.isStatic()) {
            dest.emit(184, new MethodRef(this.meth));
        } else {
            dest.emit(182, new MethodRef(this.meth));
        }
    }

    public static boolean isCastType(Class type) {
        return !type.isPrimitive() && !Object.class.equals((Object)type);
    }

    private static int firstCastArguments(Class[] tmp) {
        for (int i = 0; i < tmp.length; ++i) {
            if (!Method.isCastType(tmp[i])) continue;
            return i;
        }
        return -1;
    }

    private static void castSingleArgument(Class[] types, Code dest) {
        ClassRef ref = new ClassRef(types[0]);
        dest.emit(192, ref);
    }

    private static void castArguments(int first, Class[] tmp, Code dest) {
        int i;
        int max = tmp.length;
        int[] vars = new int[max];
        ClassRef[] types = new ClassRef[max];
        for (i = max - 1; i >= first; --i) {
            int var;
            ClassRef type;
            types[i] = type = new ClassRef(tmp[i]);
            vars[i] = var = dest.allocate(type);
            type.emitStore(dest, var);
        }
        for (i = first; i < max; ++i) {
            types[i].emitLoad(dest, vars[i]);
            if (!Method.isCastType(tmp[i])) continue;
            dest.emit(192, types[i]);
        }
    }
}

