/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.reflect;

import java.lang.reflect.InvocationTargetException;
import net.oneandone.mork.classfile.Bytecodes;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.classfile.Code;
import net.oneandone.mork.classfile.FieldRef;
import net.oneandone.mork.compiler.Util;
import net.oneandone.mork.reflect.Function;

public class Option
extends Function
implements Bytecodes {
    public static final Object TAG = new Integer(27);
    private final int optional;
    private final Function with;
    private final Class[] parameterTypes;

    public Option(Function with, int optional) {
        this.with = with;
        this.optional = optional;
        Class<?>[] tmp = this.with.getParameterTypes();
        this.parameterTypes = new Class[tmp.length];
        System.arraycopy(tmp, 0, this.parameterTypes, 0, tmp.length);
        this.parameterTypes[this.optional] = ClassRef.wrappedType(this.parameterTypes[this.optional]);
    }

    @Override
    public String getName() {
        return this.with.getName();
    }

    public Class getReturnType() {
        return this.with.getReturnType();
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class[] getExceptionTypes() {
        return this.with.getExceptionTypes();
    }

    @Override
    public Object invoke(Object[] vals) throws InvocationTargetException {
        if (vals[this.optional] == TAG) {
            vals[this.optional] = new ClassRef(this.getParameterTypes()[this.optional]).getDefault();
        }
        return this.with.invoke(vals);
    }

    @Override
    public void translate(Code dest) {
        int i;
        Class[] tmp = this.getParameterTypes();
        int ofs = this.optional + 1;
        int max = tmp.length - ofs;
        int[] vars = new int[max];
        ClassRef[] types = new ClassRef[max];
        for (i = max - 1; i >= 0; --i) {
            int var;
            ClassRef type;
            types[i] = type = new ClassRef(tmp[i + ofs]);
            vars[i] = var = dest.allocate(type);
            type.emitStore(dest, var);
        }
        Class<?> optType = this.with.getParameterTypes()[this.optional];
        int unwrapOptionLabel = dest.declareLabel();
        int pushTailingLabel = dest.declareLabel();
        dest.emit(89);
        dest.emit(178, new FieldRef(new ClassRef(Option.class), "TAG", ClassRef.OBJECT));
        dest.emit(166, unwrapOptionLabel);
        dest.emit(87);
        new ClassRef(optType).emitDefault(dest);
        dest.emit(167, pushTailingLabel);
        dest.defineLabel(unwrapOptionLabel);
        Util.unwrap(optType, dest);
        dest.defineLabel(pushTailingLabel);
        for (i = 0; i < max; ++i) {
            types[i].emitLoad(dest, vars[i]);
        }
        this.with.translate(dest);
    }
}

