/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.oneandone.mork.classfile.ClassRef;
import net.oneandone.mork.reflect.Function;

public class Selection {
    private final Function[] functions;

    public Selection() {
        this.functions = new Function[0];
    }

    public Selection(Function fn) {
        this.functions = new Function[]{fn};
    }

    public Selection(Collection fns) {
        this.functions = new Function[fns.size()];
        Iterator iterator = fns.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            this.functions[i] = (Function)iterator.next();
            ++i;
        }
    }

    public Selection(Function[] functionsInit) {
        this.functions = functionsInit;
    }

    public Class calcResult() {
        Class<?> result = null;
        for (int i = 0; i < this.functions.length; ++i) {
            Class<?> tmp = this.functions[i].getReturnType();
            if ((result = ClassRef.commonBase(result, tmp = ClassRef.wrappedType(tmp))) != null) continue;
            throw new RuntimeException();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.functions.length;
    }

    public Function getFunction(int i) {
        return this.functions[i];
    }

    public Function getFunction() {
        if (this.functions.length == 1) {
            return this.functions[0];
        }
        return null;
    }

    public Selection add(Selection operand) {
        if (operand.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return operand;
        }
        Function[] fns = new Function[this.size() + operand.size()];
        System.arraycopy(this.functions, 0, fns, 0, this.size());
        System.arraycopy(operand.functions, 0, fns, this.size(), operand.size());
        return new Selection(fns);
    }

    public Selection restrictArgumentType(int arg, Class type) {
        ArrayList<Function> lst = new ArrayList<Function>();
        for (int i = 0; i < this.functions.length; ++i) {
            Class<?>[] paras = this.functions[i].getParameterTypes();
            if (arg >= paras.length) continue;
            Class<?> tmp = paras[arg];
            if (!(tmp = ClassRef.wrappedType(tmp)).isAssignableFrom(type)) continue;
            lst.add(this.functions[i]);
        }
        return new Selection(lst);
    }

    public Selection restrictArgumentCount(int count) {
        ArrayList<Function> lst = new ArrayList<Function>();
        for (int i = 0; i < this.functions.length; ++i) {
            if (this.functions[i].getParameterTypes().length != count) continue;
            lst.add(this.functions[i]);
        }
        return new Selection(lst);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("selection {\n");
        for (int i = 0; i < this.functions.length; ++i) {
            buffer.append("  ");
            buffer.append(this.functions[i].toString());
            buffer.append('\n');
        }
        buffer.append("}");
        return buffer.toString();
    }
}

