/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.regexpr;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.regexpr.Action;
import net.oneandone.mork.regexpr.ActionException;
import net.oneandone.mork.regexpr.Range;
import net.oneandone.mork.regexpr.RegExpr;
import net.oneandone.mork.regexpr.Sequence;

public class Choice
extends RegExpr {
    private final RegExpr[] body;

    public Choice(RegExpr ... body) {
        this.body = body;
    }

    public static RegExpr createRightOptional(RegExpr left, RegExpr right) {
        if (right == null) {
            return left;
        }
        return new Choice(left, right);
    }

    public static RegExpr createLeftOptional(RegExpr left, RegExpr right) {
        if (left == null) {
            return right;
        }
        return new Choice(left, right);
    }

    public static Choice createOption(RegExpr e) {
        return new Choice(e, new Sequence());
    }

    public static Choice createNot(RegExpr expr) {
        ArrayList<RegExpr> ranges = new ArrayList<RegExpr>();
        if (!Choice.getRanges(expr, ranges)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Range> result = new ArrayList<Range>();
        result.add(Range.ALL);
        int max = ranges.size();
        for (int i = 0; i < max; ++i) {
            Range.remove(result, (Range)ranges.get(i));
        }
        RegExpr[] args = new RegExpr[result.size()];
        result.toArray(args);
        return new Choice(args);
    }

    public static boolean getRanges(RegExpr expr, List<RegExpr> result) {
        if (expr instanceof Range) {
            result.add(expr);
            return true;
        }
        if (expr instanceof Choice) {
            Choice alt = (Choice)expr;
            for (int i = 0; i < alt.body.length; ++i) {
                if (Choice.getRanges(alt.body[i], result)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof Sequence) {
            return ((Sequence)expr).getRanges(result);
        }
        return false;
    }

    @Override
    public Object visit(Action action) throws ActionException {
        Object[] tmps = new Object[this.body.length];
        for (int i = 0; i < tmps.length; ++i) {
            tmps[i] = this.body[i].visit(action);
        }
        return action.choice(tmps);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (int i = 0; i < this.body.length; ++i) {
            buf.append('|');
            buf.append(this.body[i].toString());
        }
        buf.append("|)");
        return buf.toString();
    }
}

