/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.regexpr;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.regexpr.Action;
import net.oneandone.mork.regexpr.ActionException;
import net.oneandone.mork.regexpr.RegExpr;

public class Range
extends RegExpr {
    private char first;
    private char last;
    public static final Range ALL = new Range('\u0000', '\uffff');

    public Range(char firstAndLast) {
        this(firstAndLast, firstAndLast);
    }

    public Range(char first, char last) {
        if (first > last) {
            throw new IllegalArgumentException();
        }
        this.first = first;
        this.last = last;
    }

    public char getFirst() {
        return this.first;
    }

    public char getLast() {
        return this.last;
    }

    public boolean contains(char c) {
        return this.first <= c && c <= this.last;
    }

    public boolean contains(Range operand) {
        return this.contains(operand.first) && this.contains(operand.last);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Range) {
            Range range = (Range)obj;
            return this.first == range.first && this.last == range.last;
        }
        return false;
    }

    public int hashCode() {
        return this.first;
    }

    @Override
    public Object visit(Action action) throws ActionException {
        return action.range(this.first, this.last);
    }

    public Range and(Range operand) {
        int lst;
        int fst = Math.max(this.first, operand.first);
        if (fst <= (lst = Math.min(this.last, operand.last))) {
            return new Range((char)fst, (char)lst);
        }
        return null;
    }

    public boolean touches(Range operand) {
        int lst;
        int fst = Math.max(this.first, operand.first);
        return fst <= (lst = Math.min(this.last, operand.last));
    }

    public static void normalizeRanges(List<Range> ranges) {
        for (int todo = 0; todo < ranges.size(); ++todo) {
            Range current = ranges.get(todo);
            int max = ranges.size();
            for (int i = todo + 1; i < max; ++i) {
                Range op = ranges.get(i);
                Range and = current.and(op);
                if (and == null) continue;
                current.remove(and, ranges);
                op.remove(and, ranges);
                ranges.remove(i);
                --i;
                --max;
                current = and;
            }
            ranges.set(todo, current);
        }
    }

    public static void remove(List here, Range operand) {
        ArrayList<Range> result = new ArrayList<Range>();
        int max = here.size();
        for (int i = 0; i < max; ++i) {
            Range tmp = (Range)here.get(i);
            if (tmp.and(operand) != null) {
                tmp.remove(operand, result);
                continue;
            }
            result.add(tmp);
        }
        here.clear();
        here.addAll(result);
    }

    public void remove(Range operand, List<Range> result) {
        if (this.first < operand.first) {
            result.add(new Range(this.first, (char)(operand.first - '\u0001')));
        }
        if (operand.last < this.last) {
            result.add(new Range((char)(operand.last + '\u0001'), this.last));
        }
    }

    public String toString() {
        if (this.first == this.last) {
            return "[" + Range.charString(this.first) + "]";
        }
        return "[" + Range.charString(this.first) + "-" + Range.charString(this.last) + "]";
    }

    private static String charString(char c) {
        if (c >= ' ') {
            return "'" + c + "' (" + c + ")";
        }
        return "(" + c + ")";
    }
}

