/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.regexpr;

import java.util.List;
import net.oneandone.mork.regexpr.Action;
import net.oneandone.mork.regexpr.ActionException;
import net.oneandone.mork.regexpr.Choice;
import net.oneandone.mork.regexpr.Range;
import net.oneandone.mork.regexpr.RegExpr;

public class Sequence
extends RegExpr {
    private RegExpr[] body;

    public Sequence() {
        this.body = new RegExpr[0];
    }

    public Sequence(RegExpr[] bodyInit) {
        this.body = bodyInit;
    }

    public Sequence(RegExpr left, RegExpr right) {
        if (left == null || right == null) {
            throw new NullPointerException();
        }
        this.body = new RegExpr[2];
        this.body[0] = left;
        this.body[1] = right;
    }

    public static RegExpr createKeyword(String str) {
        if (str.length() == 1) {
            return new Range(str.charAt(0));
        }
        RegExpr[] chars = new RegExpr[str.length()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = new Range(str.charAt(i));
        }
        return new Sequence(chars);
    }

    public static Sequence createTimes(RegExpr body, int count) {
        RegExpr[] seq = new RegExpr[count];
        for (int i = 0; i < count; ++i) {
            seq[i] = body;
        }
        return new Sequence(seq);
    }

    public boolean getRanges(List<RegExpr> result) {
        if (this.body.length != 1) {
            return false;
        }
        return Choice.getRanges(this.body[0], result);
    }

    @Override
    public Object visit(Action action) throws ActionException {
        Object[] tmps = new Object[this.body.length];
        for (int i = 0; i < tmps.length; ++i) {
            tmps[i] = this.body[i].visit(action);
        }
        return action.sequence(tmps);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (int i = 0; i < this.body.length; ++i) {
            buf.append(' ');
            buf.append(this.body[i].toString());
        }
        buf.append(" )");
        return buf.toString();
    }
}

