/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import java.io.IOException;
import java.io.Reader;
import net.oneandone.mork.scanner.Pages;
import net.oneandone.mork.scanner.Position;

public class Buffer {
    private boolean eof;
    private int start;
    private Position position;
    private final Pages pages;
    private final int pageSize;
    private int endPageIdx;
    private char[] endPage;
    private int end;
    private int endFilled;

    public Buffer() {
        this(8192);
    }

    public Buffer(int pageSize) {
        if (pageSize == 0) {
            throw new IllegalArgumentException();
        }
        this.pageSize = pageSize;
        this.pages = new Pages(pageSize);
    }

    public void open(Position position, Reader src) {
        this.position = position;
        this.eof = false;
        this.start = 0;
        this.pages.open(src);
        this.endPageIdx = 0;
        this.endPage = this.pages.get(0);
        this.end = 0;
        this.endFilled = this.pages.getFilled(0);
    }

    public void assertInvariant() {
        if (this.start > this.pages.getSize()) {
            throw new IllegalStateException();
        }
        if (this.start > this.pageSize) {
            throw new IllegalStateException();
        }
        if (this.start > this.getEndOfs()) {
            throw new IllegalStateException();
        }
        if (this.end > this.endFilled) {
            throw new IllegalStateException();
        }
        if (this.endPage != this.pages.get(this.endPageIdx)) {
            throw new IllegalStateException();
        }
    }

    public int getEndOfs() {
        return this.endPageIdx * this.pageSize + this.end;
    }

    public void resetEndOfs(int ofs) {
        if (this.endPageIdx == 0) {
            this.end = ofs;
        } else {
            this.endPageIdx = ofs / this.pageSize;
            this.end = ofs % this.pageSize;
            if (this.end == 0 && this.pages.getLastNo() == this.endPageIdx) {
                this.end += this.pageSize;
                --this.endPageIdx;
            }
            this.endPage = this.pages.get(this.endPageIdx);
            this.endFilled = this.pages.getFilled(this.endPageIdx);
        }
    }

    public boolean wasEof() {
        return this.eof && this.getEndOfs() == this.pages.getSize();
    }

    public int read() throws IOException {
        if (this.end == this.endFilled) {
            switch (this.pages.read(this.endPageIdx, this.endFilled)) {
                case -1: {
                    this.eof = true;
                    return -1;
                }
                case 0: {
                    this.endFilled = this.pages.getFilled(this.endPageIdx);
                    break;
                }
                case 1: {
                    ++this.endPageIdx;
                    this.end = 0;
                    this.endPage = this.pages.get(this.endPageIdx);
                    this.endFilled = this.pages.getFilled(this.endPageIdx);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        return this.endPage[this.end++];
    }

    public void eat() {
        if (this.endPageIdx == 0) {
            this.position.update(this.endPage, this.start, this.end);
            this.start = this.end;
        } else {
            this.position.update(this.pages.get(0), this.start, this.pageSize);
            for (int i = 1; i < this.endPageIdx; ++i) {
                this.position.update(this.pages.get(i), 0, this.pageSize);
            }
            this.pages.shrink(this.endPageIdx);
            this.endPageIdx = 0;
            this.endPage = this.pages.get(0);
            this.start = this.end;
            this.position.update(this.endPage, 0, this.start);
        }
    }

    public String createString() {
        if (this.endPageIdx == 0) {
            return new String(this.endPage, this.start, this.end - this.start);
        }
        char[] buffer = new char[this.endPageIdx * this.pageSize + this.end - this.start];
        int count = this.pageSize - this.start;
        System.arraycopy(this.pages.get(0), this.start, buffer, 0, count);
        for (int i = 1; i < this.endPageIdx; ++i) {
            System.arraycopy(this.pages.get(i), 0, buffer, count, this.pageSize);
            count += this.pageSize;
        }
        System.arraycopy(this.pages.get(this.endPageIdx), 0, buffer, count, this.end);
        return new String(buffer);
    }

    public void getPosition(Position result) {
        result.set(this.position);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("buffer {");
        buf.append("\n  srcEof     = ").append(this.eof);
        buf.append("\n  start      = ").append(this.start);
        buf.append("\n  endPageIdx = ").append(this.endPageIdx);
        buf.append("\n  end        = ").append(this.end);
        buf.append("\n  endUsed    = ").append(this.endFilled);
        buf.append(this.pages.toString());
        buf.append("\n}");
        return buf.toString();
    }
}

