/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import net.oneandone.mork.regexpr.Range;
import net.oneandone.mork.scanner.FA;
import net.oneandone.mork.scanner.State;

public class CompleteFA {
    public static FA create(FA fa, int errorSi) {
        int faSize = fa.size();
        FA cfa = new FA();
        for (int si = 0; si < faSize; ++si) {
            int width;
            State faState = fa.get(si);
            if (cfa.add(faState.getLabel()) != si) {
                throw new RuntimeException();
            }
            State cfaState = cfa.get(si);
            if (fa.getStart() == si) {
                cfa.setStart(si);
            }
            if (fa.isEnd(si)) {
                cfa.setEnd(si);
            }
            int[] sorted = faState.sortRanges();
            int nextChar = 0;
            for (int idx = 0; idx < sorted.length; idx += width) {
                width = CompleteFA.countConsecutive(faState, sorted, idx);
                Range range = CompleteFA.firstToLast(faState, sorted, idx, width);
                int nextSi = faState.getEnd(sorted[idx]);
                if (nextChar < range.getFirst()) {
                    cfaState.add(errorSi, new Range((char)nextChar, (char)(range.getFirst() - '\u0001')));
                }
                cfaState.add(faState.getEnd(sorted[idx]), range);
                nextChar = range.getLast() + '\u0001';
            }
            if (nextChar > 65535) continue;
            cfaState.add(errorSi, new Range((char)nextChar, '\uffff'));
        }
        return cfa;
    }

    private static int countConsecutive(State state, int[] tis, int ofs) {
        Range tmp;
        int i;
        int endSi = state.getEnd(tis[ofs]);
        int nextChar = state.getInput(tis[ofs]).getLast() + '\u0001';
        for (i = ofs + 1; i < tis.length && state.getEnd(tis[i]) == endSi && (tmp = state.getInput(tis[i])).getFirst() == nextChar; ++i) {
            nextChar = tmp.getLast() + '\u0001';
        }
        return i - ofs;
    }

    private static Range firstToLast(State state, int[] tis, int ofs, int width) {
        Range left = state.getInput(tis[ofs]);
        Range right = state.getInput(tis[ofs + width - 1]);
        return new Range(left.getFirst(), right.getLast());
    }
}

