/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import java.util.ArrayList;
import net.oneandone.mork.regexpr.Range;
import net.oneandone.mork.scanner.FA;
import net.oneandone.mork.scanner.Label;
import net.oneandone.mork.scanner.State;
import net.oneandone.sushi.util.IntBitSet;

public class DFA {
    public static FA create(FA nfa) {
        if (nfa.getStart() == -1) {
            throw new IllegalArgumentException();
        }
        IntBitSet[] epsilonClosures = nfa.epsilonClosures();
        IntBitSet closure = new IntBitSet();
        closure.add(nfa.getStart());
        closure.addAllSets(epsilonClosures);
        FA dfa = new FA();
        dfa.setStart(dfa.add(closure));
        for (int dfaIdx = 0; dfaIdx < dfa.size(); ++dfaIdx) {
            int transition;
            int max;
            State nfaState;
            State dfaState = dfa.get(dfaIdx);
            closure = (IntBitSet)dfaState.getLabel();
            ArrayList<Range> ranges = new ArrayList<Range>();
            int nfaIdx = closure.first();
            while (nfaIdx != -1) {
                if (nfa.isEnd(nfaIdx)) {
                    dfa.setEnd(dfaIdx);
                }
                nfaState = nfa.get(nfaIdx);
                max = nfaState.size();
                for (transition = 0; transition < max; ++transition) {
                    Range tmp = nfaState.getInput(transition);
                    if (tmp == null) continue;
                    ranges.add(tmp);
                }
                nfaIdx = closure.next(nfaIdx);
            }
            Range.normalizeRanges(ranges);
            int rangeCount = ranges.size();
            for (int i = 0; i < rangeCount; ++i) {
                Range small = (Range)ranges.get(i);
                IntBitSet nextClosure = new IntBitSet();
                nfaIdx = closure.first();
                while (nfaIdx != -1) {
                    nfaState = nfa.get(nfaIdx);
                    max = nfaState.size();
                    for (transition = 0; transition < max; ++transition) {
                        Range large = nfaState.getInput(transition);
                        if (large == null || !large.contains(small)) continue;
                        nextClosure.add(nfaState.getEnd(transition));
                    }
                    nfaIdx = closure.next(nfaIdx);
                }
                nextClosure.addAllSets(epsilonClosures);
                int nextDfaIdx = dfa.find(nextClosure);
                if (nextDfaIdx == -1) {
                    nextDfaIdx = dfa.add(nextClosure);
                }
                dfaState.add(nextDfaIdx, small);
            }
        }
        Label.combineLabels(dfa, nfa);
        return dfa;
    }
}

