/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import java.util.ArrayList;
import net.oneandone.mork.grammar.Rule;
import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.mork.regexpr.Action;
import net.oneandone.mork.regexpr.ActionException;
import net.oneandone.mork.regexpr.Choice;
import net.oneandone.mork.regexpr.Loop;
import net.oneandone.mork.regexpr.Range;
import net.oneandone.mork.regexpr.RegExpr;
import net.oneandone.mork.regexpr.Sequence;
import net.oneandone.mork.regexpr.Without;
import net.oneandone.sushi.util.IntBitSet;

public class Expander
extends Action {
    private final Rule[] rules;
    private final IntBitSet used;
    private final IntBitSet expanding;
    private final StringArrayList symbolTable;

    public Expander(Rule[] rules, StringArrayList symbolTable) {
        this.rules = rules;
        this.used = new IntBitSet();
        this.expanding = new IntBitSet();
        this.symbolTable = symbolTable;
    }

    public IntBitSet getUsed() {
        return this.used;
    }

    public RegExpr run(RegExpr re) throws ActionException {
        return (RegExpr)re.visit(this);
    }

    @Override
    public Object symbol(int symbol) throws ActionException {
        RegExpr re;
        if (this.expanding.contains(symbol)) {
            throw new ActionException("illegal recursion in scanner section for symbol " + this.symbolTable.getOrIndex(symbol));
        }
        this.used.add(symbol);
        ArrayList<RegExpr> lst = new ArrayList<RegExpr>();
        for (int i = 0; i < this.rules.length; ++i) {
            if (this.rules[i].getLeft() != symbol) continue;
            lst.add(this.rules[i].getRight());
        }
        int max = lst.size();
        if (max == 0) {
            throw new ActionException("illegal reference to parser symbol '" + this.symbolTable.getOrIndex(symbol) + "' from scanner section");
        }
        if (max == 1) {
            re = (RegExpr)lst.get(0);
        } else {
            RegExpr[] args = new RegExpr[max];
            lst.toArray(args);
            re = new Choice(args);
        }
        this.expanding.add(symbol);
        re = (RegExpr)re.visit(this);
        this.expanding.remove(symbol);
        return re;
    }

    @Override
    public Object range(char first, char last) {
        return new Range(first, last);
    }

    @Override
    public Object choice(Object[] body) {
        RegExpr[] args = new RegExpr[body.length];
        System.arraycopy(body, 0, args, 0, body.length);
        return new Choice(args);
    }

    @Override
    public Object sequence(Object[] body) {
        RegExpr[] args = new RegExpr[body.length];
        System.arraycopy(body, 0, args, 0, body.length);
        return new Sequence(args);
    }

    @Override
    public Object loop(Object rawBody) {
        return new Loop((RegExpr)rawBody);
    }

    @Override
    public Object without(Object left, Object right) {
        return new Without((RegExpr)left, (RegExpr)right);
    }
}

