/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import net.oneandone.mork.scanner.State;
import net.oneandone.sushi.util.IntBitSet;

public class FA {
    private static final int INITIAL_STATES = 128;
    private State[] states;
    private int used;
    private int start;
    private IntBitSet ends;

    public FA() {
        this.states = new State[128];
        this.start = -1;
        this.used = 0;
        this.ends = new IntBitSet();
    }

    public FA(FA orig) {
        this.states = new State[orig.states.length];
        this.used = orig.used;
        for (int i = 0; i < this.used; ++i) {
            this.states[i] = new State(orig.states[i], 0);
        }
        this.start = orig.start;
        this.ends = new IntBitSet(orig.ends);
    }

    private void ensureCapacity(int idx) {
        if (idx >= this.states.length) {
            int size = this.states.length;
            while (idx >= size) {
                if ((size *= 2) >= 0) continue;
                size = idx + 1;
                break;
            }
            State[] grown = new State[size];
            System.arraycopy(this.states, 0, grown, 0, this.used);
            this.states = grown;
        }
    }

    private void checkState(int state) {
        if (state > this.used || state < 0) {
            throw new IllegalArgumentException();
        }
    }

    public int add(Object label) {
        this.ensureCapacity(this.used);
        this.states[this.used] = new State(label);
        return this.used++;
    }

    public State get(int idx) {
        return this.states[idx];
    }

    public int size() {
        return this.used;
    }

    public int find(Object label) {
        if (label == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.used; ++i) {
            if (!label.equals(this.states[i].getLabel())) continue;
            return i;
        }
        return -1;
    }

    public void setEndLabels(Object label) {
        int si = this.ends.first();
        while (si != -1) {
            this.states[si].setLabel(label);
            si = this.ends.next(si);
        }
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int state) {
        this.start = state;
    }

    public void setEnd(int state) {
        this.checkState(state);
        this.ends.add(state);
    }

    public void resetEnd(int state) {
        this.checkState(state);
        this.ends.remove(state);
    }

    public boolean isEnd(int state) {
        this.checkState(state);
        return this.ends.contains(state);
    }

    public int getFirstEnd() {
        return this.ends.first();
    }

    public int getNextEnd(int state) {
        return this.ends.next(state);
    }

    public void sequence(FA seq) {
        int idx;
        int relocation = this.append(seq);
        if (seq.start != -1) {
            idx = this.ends.first();
            while (idx != -1) {
                this.states[idx].add(relocation + seq.start, null);
                idx = this.ends.next(idx);
            }
        }
        this.ends.clear();
        idx = seq.ends.first();
        while (idx != -1) {
            this.ends.add(idx + relocation);
            idx = seq.ends.next(idx);
        }
    }

    public void alternate(FA alt) {
        int relocation = this.append(alt);
        int newStart = this.add(null);
        if (this.start != -1) {
            this.states[newStart].add(this.start, null);
        }
        if (alt.start != -1) {
            this.states[newStart].add(alt.start + relocation, null);
        }
        this.start = newStart;
        int newEnd = this.add(null);
        int idx = this.ends.first();
        while (idx != -1) {
            this.states[idx].add(newEnd, null);
            idx = this.ends.next(idx);
        }
        idx = alt.ends.first();
        while (idx != -1) {
            this.states[relocation + idx].add(newEnd, null);
            idx = alt.ends.next(idx);
        }
        this.ends.clear();
        this.ends.add(newEnd);
    }

    public void star() {
        this.loop(true);
    }

    public void plus() {
        this.loop(false);
    }

    private void loop(boolean optional) {
        int newStart = this.add(null);
        int newEnd = this.add(null);
        if (optional) {
            this.states[newStart].add(newEnd, null);
        }
        if (this.start != -1) {
            this.states[newStart].add(this.start, null);
        }
        int idx = this.ends.first();
        while (idx != -1) {
            if (this.start != -1) {
                this.states[idx].add(this.start, null);
            }
            this.states[idx].add(newEnd, null);
            idx = this.ends.next(idx);
        }
        this.start = newStart;
        this.ends.clear();
        this.ends.add(newEnd);
    }

    public void not() {
        IntBitSet tmp = new IntBitSet();
        tmp.addRange(0, this.used - 1);
        tmp.removeAll(this.ends);
        this.ends = tmp;
    }

    private int append(FA add) {
        int relocation = this.used;
        this.ensureCapacity(this.used + add.used);
        for (int idx = 0; idx < add.used; ++idx) {
            this.states[relocation + idx] = new State(add.states[idx], relocation);
        }
        this.used += add.used;
        return relocation;
    }

    public IntBitSet[] epsilonClosures() {
        boolean repeat;
        int si;
        IntBitSet[] result = new IntBitSet[this.used];
        int[] size = new int[this.used];
        for (si = 0; si < this.used; ++si) {
            IntBitSet tmp = new IntBitSet();
            this.states[si].epsilonClosure(tmp);
            result[si] = tmp;
            size[si] = tmp.size();
        }
        do {
            repeat = false;
            for (si = 0; si < this.used; ++si) {
                result[si].addAllSets(result);
                int nextSize = result[si].size();
                if (nextSize <= size[si]) continue;
                size[si] = nextSize;
                repeat = true;
            }
        } while (repeat);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("start = " + this.start + " end = " + this.ends.toString() + "\n");
        for (int idx = 0; idx < this.used; ++idx) {
            result.append("  " + idx + " ");
            result.append(this.states[idx].toString());
            result.append("\n");
        }
        result.append("fa end\n");
        return result.toString();
    }
}

