/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import java.io.PrintWriter;
import net.oneandone.mork.grammar.Rule;
import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.mork.regexpr.Action;
import net.oneandone.mork.regexpr.ActionException;
import net.oneandone.mork.regexpr.Choice;
import net.oneandone.mork.regexpr.Range;
import net.oneandone.mork.regexpr.RegExpr;
import net.oneandone.mork.scanner.CompleteFA;
import net.oneandone.mork.scanner.DFA;
import net.oneandone.mork.scanner.Expander;
import net.oneandone.mork.scanner.FA;
import net.oneandone.mork.scanner.Label;
import net.oneandone.mork.scanner.Minimizer;
import net.oneandone.sushi.util.IntBitSet;

public class FABuilder
extends Action {
    private FA fa;
    private int errorSi;
    private IntBitSet inlines;
    private StringArrayList symbolTable;

    public static FABuilder run(Rule[] rules, IntBitSet terminals, StringArrayList symbolTable, PrintWriter verbose) throws ActionException {
        Label label;
        Expander expander = new Expander(rules, symbolTable);
        FABuilder builder = new FABuilder(symbolTable);
        builder.fa = (FA)new Choice(new RegExpr[0]).visit(builder);
        if (verbose != null) {
            verbose.println("building NFA");
        }
        for (int i = 0; i < rules.length; ++i) {
            if (!terminals.contains(rules[i].getLeft())) continue;
            RegExpr expanded = (RegExpr)rules[i].getRight().visit(expander);
            FA alt = (FA)expanded.visit(builder);
            label = new Label(rules[i].getLeft());
            alt.setEndLabels(label);
            builder.fa.alternate(alt);
        }
        if (verbose != null) {
            verbose.println("building DFA");
        }
        builder.fa = DFA.create(builder.fa);
        if (verbose != null) {
            verbose.println("complete DFA");
        }
        builder.errorSi = builder.fa.add(null);
        builder.fa = CompleteFA.create(builder.fa, builder.errorSi);
        if (verbose != null) {
            verbose.println("minimized DFA");
        }
        Minimizer minimizer = new Minimizer(builder.fa);
        builder.fa = minimizer.run();
        builder.errorSi = minimizer.getNewSi(builder.errorSi);
        builder.inlines = expander.getUsed();
        if (builder.fa.isEnd(builder.fa.getStart())) {
            label = (Label)builder.fa.get(builder.fa.getStart()).getLabel();
            throw new ActionException("Scanner accepts the empty word for symbol " + symbolTable.get(label.getSymbol()) + ".\nThis is illegal because it might cause infinite loops when scanning.");
        }
        return builder;
    }

    public FA getFA() {
        return this.fa;
    }

    public IntBitSet getInlines() {
        return this.inlines;
    }

    public int getErrorState() {
        return this.errorSi;
    }

    private FABuilder(StringArrayList symbolTable) {
        this.symbolTable = symbolTable;
    }

    @Override
    public Object symbol(int symbol) throws ActionException {
        throw new ActionException("illegal symbol in scanner section: " + this.symbolTable.getOrIndex(symbol));
    }

    @Override
    public Object range(char first, char last) {
        FA fa = new FA();
        int start = fa.add(null);
        fa.setStart(start);
        int end = fa.add(null);
        fa.setEnd(end);
        fa.get(start).add(end, new Range(first, last));
        return fa;
    }

    @Override
    public Object choice(Object[] body) {
        FA result = new FA();
        int i = result.add(null);
        result.setStart(i);
        for (i = 0; i < body.length; ++i) {
            FA tmp = (FA)body[i];
            result.alternate(tmp);
        }
        return result;
    }

    @Override
    public Object sequence(Object[] body) {
        FA result = new FA();
        int i = result.add(null);
        result.setStart(i);
        result.setEnd(i);
        for (i = 0; i < body.length; ++i) {
            FA tmp = (FA)body[i];
            result.sequence(tmp);
        }
        return result;
    }

    @Override
    public Object loop(Object rawBody) {
        FA body = (FA)rawBody;
        body.plus();
        return body;
    }

    @Override
    public Object without(Object a, Object b) {
        FA result = DFA.create((FA)a);
        result.not();
        result.alternate((FA)b);
        result = DFA.create(result);
        result.not();
        return result;
    }
}

