/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import net.oneandone.mork.scanner.FA;
import net.oneandone.mork.scanner.State;
import net.oneandone.sushi.util.IntBitSet;

public class Label {
    private IntBitSet symbols = new IntBitSet();

    public Label() {
    }

    public Label(int symbol) {
        this.symbols.add(symbol);
    }

    public IntBitSet getConflict(IntBitSet op) {
        IntBitSet result = new IntBitSet(this.symbols);
        result.retainAll(op);
        if (result.size() > 1) {
            return result;
        }
        return null;
    }

    public static void resolveConflicts(FA fa, int[] prios) {
        int max = fa.size();
        for (int i = 0; i < max; ++i) {
            Label label = (Label)fa.get(i).getLabel();
            if (label == null) continue;
            label.resolveConflicts(prios);
        }
    }

    public void resolveConflicts(int[] prios) {
        for (int i = 0; i < prios.length; ++i) {
            if (!this.symbols.contains(prios[i])) continue;
            this.symbols = new IntBitSet();
            this.symbols.add(prios[i]);
            return;
        }
        throw new RuntimeException();
    }

    public int getSymbol() {
        if (this.symbols.size() != 1) {
            throw new RuntimeException();
        }
        return this.symbols.first();
    }

    public int getSymbol(IntBitSet mode) {
        int result = -1;
        int sym = this.symbols.first();
        while (sym != -1) {
            if (mode.contains(sym)) {
                if (result != -1) {
                    throw new RuntimeException("ambiguous: " + result + " " + sym);
                }
                result = sym;
            }
            sym = this.symbols.next(sym);
        }
        return result;
    }

    public static boolean sameSymbols(FA fa, int siA, int siB) {
        Label a = (Label)fa.get(siA).getLabel();
        Label b = (Label)fa.get(siB).getLabel();
        return a.symbols.equals((Object)b.symbols);
    }

    public static void combineLabels(FA front, FA back) {
        int max = front.size();
        for (int si = 0; si < max; ++si) {
            State state = front.get(si);
            state.setLabel(Label.combineLabel(back, (IntBitSet)state.getLabel()));
        }
    }

    private static Label combineLabel(FA fa, IntBitSet states) {
        Label result = null;
        int si = states.first();
        while (si != -1) {
            Label tmp = (Label)fa.get(si).getLabel();
            if (tmp != null) {
                if (result == null) {
                    result = new Label();
                }
                result.symbols.addAll(tmp.symbols);
            }
            si = states.next(si);
        }
        return result;
    }

    public String toString() {
        return this.symbols.toString();
    }
}

