/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import net.oneandone.mork.regexpr.Range;
import net.oneandone.mork.scanner.FA;
import net.oneandone.mork.scanner.Label;
import net.oneandone.sushi.util.IntArrayList;
import net.oneandone.sushi.util.IntBitSet;

public class Minimizer {
    private static final IntArrayList YES = new IntArrayList();
    private static final IntArrayList NO = new IntArrayList();
    private static final IntArrayList UNKNOWN = null;
    private final FA fa;
    private final int size;
    private final IntArrayList[][] distinct;
    private final int[] old2new;

    public Minimizer(FA fa) {
        int leftSi;
        this.fa = fa;
        this.size = fa.size();
        this.old2new = new int[this.size];
        this.distinct = new IntArrayList[this.size][];
        for (leftSi = 0; leftSi < this.size; ++leftSi) {
            this.distinct[leftSi] = new IntArrayList[leftSi];
        }
        leftSi = fa.getFirstEnd();
        while (leftSi != -1) {
            int rightSi;
            for (rightSi = 0; rightSi < leftSi; ++rightSi) {
                if (fa.isEnd(rightSi) && Label.sameSymbols(fa, leftSi, rightSi)) continue;
                this.distinct[leftSi][rightSi] = YES;
            }
            for (rightSi = leftSi + 1; rightSi < this.size; ++rightSi) {
                if (fa.isEnd(rightSi) && Label.sameSymbols(fa, leftSi, rightSi)) continue;
                this.distinct[rightSi][leftSi] = YES;
            }
            leftSi = fa.getNextEnd(leftSi);
        }
    }

    public int getNewSi(int si) {
        return this.old2new[si];
    }

    public FA run() {
        this.distinguish();
        return this.collect();
    }

    private FA collect() {
        int faSi;
        int resultSi;
        IntBitSet states;
        FA result = new FA();
        for (int leftSi = 0; leftSi < this.size; ++leftSi) {
            int rightSi;
            states = new IntBitSet();
            for (rightSi = 0; rightSi < leftSi; ++rightSi) {
                if (this.distinct[leftSi][rightSi] == YES) continue;
                states.add(rightSi);
            }
            states.add(rightSi++);
            while (rightSi < this.size) {
                if (this.distinct[rightSi][leftSi] != YES) {
                    states.add(rightSi);
                }
                ++rightSi;
            }
            if (result.find(states) != -1) continue;
            resultSi = result.add(states);
            faSi = states.first();
            while (faSi != -1) {
                this.old2new[faSi] = resultSi;
                faSi = states.next(faSi);
            }
        }
        int resultSize = result.size();
        for (resultSi = 0; resultSi < resultSize; ++resultSi) {
            states = (IntBitSet)result.get(resultSi).getLabel();
            faSi = states.first();
            if (faSi == -1) {
                throw new RuntimeException();
            }
            if (this.fa.getStart() == faSi) {
                result.setStart(resultSi);
            }
            if (this.fa.isEnd(faSi)) {
                result.setEnd(resultSi);
            }
            int maxTi = this.fa.get(faSi).size();
            for (int ti = 0; ti < maxTi; ++ti) {
                result.get(resultSi).add(this.old2new[this.fa.get(faSi).getEnd(ti)], this.fa.get(faSi).getInput(ti));
            }
        }
        Label.combineLabels(result, this.fa);
        return result;
    }

    private void distinguish() {
        for (int leftSi = 0; leftSi < this.size; ++leftSi) {
            for (int rightSi = 0; rightSi < leftSi; ++rightSi) {
                IntArrayList d = this.distinct[leftSi][rightSi];
                if (d == YES) continue;
                this.distinguish(leftSi, rightSi);
            }
        }
    }

    private void distinguish(int leftSi, int rightSi) {
        int maxLeftTi = this.fa.get(leftSi).size();
        if (maxLeftTi == 0) {
            throw new IllegalArgumentException("fa not complete");
        }
        boolean foundUnknown = false;
        block0: for (int leftTi = 0; leftTi < maxLeftTi; ++leftTi) {
            Range leftRange = this.fa.get(leftSi).getInput(leftTi);
            int leftEndSi = this.fa.get(leftSi).getEnd(leftTi);
            int maxRightTi = this.fa.get(rightSi).size();
            for (int rightTi = 0; rightTi < maxRightTi; ++rightTi) {
                Range rightRange = this.fa.get(rightSi).getInput(rightTi);
                if (!leftRange.touches(rightRange)) continue;
                do {
                    int rightEndSi;
                    IntArrayList tmp;
                    if ((tmp = this.getCheckedDistinctAndAllocate(leftEndSi, rightEndSi = this.fa.get(rightSi).getEnd(rightTi))) == YES) {
                        this.setDistinct(leftSi, rightSi);
                        return;
                    }
                    if (tmp == NO) continue;
                    foundUnknown = true;
                    tmp.add(Minimizer.pair(leftSi, rightSi));
                } while (++rightTi != maxRightTi && leftRange.touches(rightRange = this.fa.get(rightSi).getInput(rightTi)));
                continue block0;
            }
            throw new IllegalArgumentException("not a cdfa");
        }
        if (!foundUnknown) {
            this.distinct[leftSi][rightSi] = NO;
        }
    }

    private void setDistinct(int leftSi, int rightSi) {
        IntArrayList tmp = this.distinct[leftSi][rightSi];
        if (tmp != YES) {
            this.distinct[leftSi][rightSi] = YES;
            if (tmp != UNKNOWN) {
                int max = tmp.size();
                for (int i = 0; i < max; ++i) {
                    int pair = tmp.get(i);
                    this.setDistinct(Minimizer.left(pair), Minimizer.right(pair));
                }
            }
        }
    }

    private IntArrayList getCheckedDistinctAndAllocate(int leftSi, int rightSi) {
        if (leftSi > rightSi) {
            IntArrayList tmp = this.distinct[leftSi][rightSi];
            if (tmp == UNKNOWN) {
                this.distinct[leftSi][rightSi] = tmp = new IntArrayList();
            }
            return tmp;
        }
        if (leftSi == rightSi) {
            return NO;
        }
        IntArrayList tmp = this.distinct[rightSi][leftSi];
        if (tmp == UNKNOWN) {
            this.distinct[rightSi][leftSi] = tmp = new IntArrayList();
        }
        return tmp;
    }

    private static int pair(int left, int right) {
        return left << 16 | right;
    }

    private static int left(int pair) {
        return pair >>> 16;
    }

    private static int right(int pair) {
        return pair & 0xFFFF;
    }
}

