/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.grammar.Rule;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.parser.ParserTable;
import net.oneandone.mork.scanner.FA;
import net.oneandone.mork.scanner.Label;
import net.oneandone.sushi.util.IntBitSet;

public class Modes {
    public static void setNone(ParserTable table) {
        int max = table.getStateCount();
        char[] parserModes = new char[max];
        table.setModes(parserModes);
    }

    public static List generate(FA fa, ParserTable table, IntBitSet whites, PrintWriter listing) throws GenericException {
        int i;
        ArrayList<IntBitSet> modes = new ArrayList<IntBitSet>();
        if (Modes.hasConflicts(fa, whites) != null) {
            throw new GenericException("scanner conflict in whitespace");
        }
        int max = table.getStateCount();
        char[] parserModes = new char[max];
        for (i = 0; i < max; ++i) {
            IntBitSet shifts = table.getShifts(i);
            shifts.addAll(whites);
            IntBitSet conflicts = Modes.hasConflicts(fa, shifts);
            if (conflicts != null) {
                throw new GenericException("scanner conflict in state " + i + ": " + conflicts);
            }
            parserModes[i] = Modes.chooseState(fa, modes, shifts);
        }
        if (listing != null) {
            listing.println("scanner modes: " + modes.size());
            for (i = 0; i < modes.size(); ++i) {
                listing.println(" mode " + i + " " + modes.get(i));
            }
            listing.println("modes for parser states: ");
            for (i = 0; i < max; ++i) {
                listing.println(" " + i + " " + parserModes[i]);
            }
        }
        table.setModes(parserModes);
        return modes;
    }

    private static char chooseState(FA fa, List<IntBitSet> modes, IntBitSet shifts) {
        int max = modes.size();
        for (int i = 0; i < max; ++i) {
            IntBitSet test = modes.get(i);
            test = new IntBitSet(test);
            test.addAll(shifts);
            if (Modes.hasConflicts(fa, test) != null) continue;
            modes.set(i, test);
            return (char)i;
        }
        modes.add(new IntBitSet(shifts));
        return (char)(modes.size() - 1);
    }

    private static IntBitSet hasConflicts(FA fa, IntBitSet symbols) {
        int max = fa.size();
        for (int si = 0; si < max; ++si) {
            IntBitSet conflict;
            Label label = (Label)fa.get(si).getLabel();
            if (label == null || (conflict = label.getConflict(symbols)) == null) continue;
            return conflict;
        }
        return null;
    }

    public static void resolveScannerConflicts(FA fa, Rule[] rules) {
        int[] prios = new int[rules.length];
        for (int i = 0; i < prios.length; ++i) {
            prios[i] = rules[i].getLeft();
        }
        Label.resolveConflicts(fa, prios);
    }
}

