/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import java.io.IOException;
import java.io.Reader;

public class Pages {
    private final int pageSize;
    private Reader src;
    private int lastNo;
    private int lastFilled;
    private char[][] pages;

    public Pages(int pageSize) {
        if (pageSize == 0) {
            throw new IllegalArgumentException();
        }
        this.pageSize = pageSize;
        this.pages = new char[2][];
        this.pages[0] = new char[pageSize];
    }

    public void open(Reader src) {
        this.src = src;
        this.lastFilled = 0;
        this.lastNo = 0;
    }

    public char[] get(int no) {
        return this.pages[no];
    }

    public int getFilled(int no) {
        return no == this.lastNo ? this.lastFilled : this.pageSize;
    }

    public int getLastNo() {
        return this.lastNo;
    }

    public int getSize() {
        return this.pageSize * this.lastNo + this.lastFilled;
    }

    public int read(int pageNo, int pageUsed) throws IOException {
        if (pageUsed < this.pageSize) {
            if (pageNo != this.lastNo) {
                throw new IllegalStateException(pageNo + " vs " + this.lastNo);
            }
            return this.fillLast() ? 0 : -1;
        }
        if (pageNo == this.lastNo) {
            this.grow();
        }
        if (this.getFilled(pageNo + 1) == 0 && !this.fillLast()) {
            return -1;
        }
        return 1;
    }

    private boolean fillLast() throws IOException {
        if (this.lastFilled == this.pageSize) {
            throw new IllegalStateException();
        }
        int count = this.src.read(this.pages[this.lastNo], this.lastFilled, this.pageSize - this.lastFilled);
        if (count <= 0) {
            if (count == 0) {
                throw new IllegalStateException();
            }
            return false;
        }
        this.lastFilled += count;
        return true;
    }

    private void grow() {
        if (this.lastFilled != this.pageSize) {
            throw new IllegalStateException();
        }
        ++this.lastNo;
        if (this.lastNo >= this.pages.length) {
            char[][] newPages = new char[this.lastNo * 5 / 2][];
            System.arraycopy(this.pages, 0, newPages, 0, this.lastNo);
            this.pages = newPages;
        }
        if (this.pages[this.lastNo] == null) {
            this.pages[this.lastNo] = new char[this.pageSize];
        }
        this.lastFilled = 0;
    }

    public void shrink(int count) {
        if (count == 0) {
            throw new IllegalArgumentException();
        }
        if (count > this.lastNo) {
            throw new IllegalArgumentException(count + " vs " + this.lastNo);
        }
        this.lastNo -= count;
        char[] keepAllocated = this.pages[0];
        System.arraycopy(this.pages, count, this.pages, 0, this.lastNo + 1);
        this.pages[this.lastNo + 1] = keepAllocated;
        for (int i = this.lastNo + 2; i < this.pages.length; ++i) {
            this.pages[i] = null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("pages {");
        for (int p = 0; p <= this.lastNo; ++p) {
            int i;
            char[] pg = this.get(p);
            builder.append("\n  page " + p + ":");
            for (i = 0; i < this.pageSize; ++i) {
                builder.append(pg[i]);
            }
            builder.append("\n    ");
            for (i = 0; i < this.pageSize; ++i) {
                builder.append(" " + pg[i]);
            }
        }
        builder.append("\n}");
        return builder.toString();
    }
}

