/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

public class Position {
    private String context;
    private int line;
    private int col;
    private int ofs;

    public Position() {
        this(null);
    }

    public Position(String context) {
        this.context = context;
        this.line = 1;
        this.col = 1;
        this.ofs = 0;
    }

    public void set(String context, int line, int col, int ofs) {
        this.context = context;
        this.line = line;
        this.col = col;
        this.ofs = ofs;
    }

    public void set(Position arg) {
        this.set(arg.context, arg.line, arg.col, arg.ofs);
    }

    public void update(char[] data, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (data[i] == '\n') {
                this.col = 1;
                ++this.line;
                continue;
            }
            ++this.col;
        }
        this.ofs += end - start;
    }

    public String getContext() {
        return this.context;
    }

    public int getOffset() {
        return this.ofs;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.col;
    }

    public String toString() {
        if (this.context != null) {
            return this.context + ":" + this.line + ":" + this.col;
        }
        return this.line + ":" + this.col;
    }
}

