/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import java.io.IOException;
import java.io.Reader;
import net.oneandone.mork.scanner.Buffer;
import net.oneandone.mork.scanner.Position;
import net.oneandone.sushi.util.IntBitSet;

public class Scanner {
    public static final int EOF = -1;
    public static final int ERROR = -2;
    public static final int ERROR_PC = 1;
    public static final int NO_TERMINAL = 2047;
    private final int start;
    private final int modeCount;
    private final char[] table;
    private final Buffer src;

    public Scanner(int start, int modeCount, char[] table, Position pos, Reader reader) {
        this.start = start;
        this.modeCount = modeCount;
        this.table = table;
        this.src = new Buffer();
        this.src.open(pos, reader);
    }

    public void getPosition(Position result) {
        this.src.getPosition(result);
    }

    public String getText() {
        return this.src.createString();
    }

    public int next(int mode) throws IOException {
        this.src.eat();
        return this.scan(mode);
    }

    public int find(int mode, IntBitSet terminals) throws IOException {
        int terminal;
        int ofs = this.src.getEndOfs();
        while ((terminal = this.scan(mode)) != -1 && !terminals.contains(terminal)) {
        }
        this.src.resetEndOfs(ofs);
        return terminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(int mode, int eof, int[] terminals) throws IOException {
        int ofs = this.src.getEndOfs();
        try {
            for (int terminal : terminals) {
                int found = this.scan(mode);
                if (found == -1) {
                    found = eof;
                }
                if (found == terminal) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.src.resetEndOfs(ofs);
        }
    }

    private int scan(int mode) throws IOException {
        int matchedTerminal = -2;
        int matchedEndOfs = 0;
        int endOfs = this.src.getEndOfs();
        int pc = this.start;
        do {
            int c;
            int terminal = this.table[pc + mode];
            pc += this.modeCount;
            if (terminal != 2047) {
                matchedTerminal = terminal;
                matchedEndOfs = endOfs;
            }
            if ((c = this.src.read()) == -1) {
                this.src.resetEndOfs(matchedEndOfs);
                return matchedTerminal == -2 ? -1 : matchedTerminal;
            }
            ++endOfs;
            while (c > this.table[pc]) {
                pc += 2;
            }
        } while ((pc = this.table[pc + 1]) != 1);
        this.src.resetEndOfs(matchedEndOfs);
        return matchedTerminal;
    }
}

