/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.parser.ParserTable;
import net.oneandone.mork.regexpr.Range;
import net.oneandone.mork.scanner.FA;
import net.oneandone.mork.scanner.Label;
import net.oneandone.mork.scanner.Modes;
import net.oneandone.mork.scanner.Position;
import net.oneandone.mork.scanner.Scanner;
import net.oneandone.mork.scanner.State;
import net.oneandone.sushi.util.IntBitSet;

public class ScannerFactory {
    public static final String SCANNER_TOO_BIG = "scanner too big";
    private final int start;
    private final int modeCount;
    private final char[] table;

    public static ScannerFactory create(FA fa, int errorSi, ParserTable parserTable, IntBitSet whites, PrintWriter verbose, PrintWriter listing) throws GenericException {
        if (listing != null) {
            listing.println("Scanner\n");
            listing.println(fa.toString());
        }
        if (verbose != null) {
            verbose.println("computing scanner modes");
        }
        List modes = Modes.generate(fa, parserTable, whites, listing);
        if (verbose != null) {
            verbose.println("building table fa");
        }
        char[] table = ScannerFactory.createTable(fa, errorSi, modes);
        return new ScannerFactory(fa.getStart(), modes.size(), table);
    }

    public static ScannerFactory createSimple(FA fa, int errorSi, IntBitSet terminals) throws GenericException {
        ArrayList<IntBitSet> modes = new ArrayList<IntBitSet>();
        modes.add(new IntBitSet(terminals));
        char[] data = ScannerFactory.createTable(fa, errorSi, modes);
        return new ScannerFactory(fa.getStart(), 1, data);
    }

    private static char[] createTable(FA fa, int errorSi, List<IntBitSet> modes) throws GenericException {
        int si;
        int modeCount = modes.size();
        int maxSi = fa.size();
        int[] ofs = new int[maxSi];
        int pc = 0;
        for (si = 0; si < maxSi; ++si) {
            if (si == errorSi) continue;
            ofs[si] = pc;
            pc += modeCount;
            pc += fa.get(si).size() * 2;
        }
        if (pc >= 65535) {
            throw new GenericException(SCANNER_TOO_BIG);
        }
        char[] table = new char[pc];
        pc = 0;
        for (si = 0; si < maxSi; ++si) {
            if (si == errorSi) continue;
            if (ofs[si] != pc) {
                throw new IllegalStateException();
            }
            State state = fa.get(si);
            for (IntBitSet mode : modes) {
                table[pc] = ScannerFactory.getEndSymbol(fa, si, mode);
                ++pc;
            }
            int maxTi = state.size();
            if (maxTi == 0) {
                throw new RuntimeException();
            }
            for (int ti = 0; ti < maxTi; ++ti) {
                Range range = state.getInput(ti);
                table[pc] = range.getLast();
                table[++pc] = state.getEnd(ti) == errorSi ? (char)'\u0001' : (char)ofs[state.getEnd(ti)];
                ++pc;
            }
        }
        if (pc != table.length) {
            throw new RuntimeException();
        }
        return table;
    }

    private static char getEndSymbol(FA fa, int si, IntBitSet modeSymbols) throws GenericException {
        if (!fa.isEnd(si)) {
            return '\u07ff';
        }
        State state = fa.get(si);
        Label label = (Label)state.getLabel();
        int endSymbol = label.getSymbol(modeSymbols);
        if (endSymbol == -1) {
            return '\u07ff';
        }
        if (endSymbol >= 2047) {
            throw new GenericException(SCANNER_TOO_BIG);
        }
        return (char)endSymbol;
    }

    public ScannerFactory(int start, int modeCount, char[] table) {
        if (start == -1) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.modeCount = modeCount;
        this.table = table;
    }

    public Scanner newInstance(Position pos, Reader src) {
        return new Scanner(this.start, this.modeCount, this.table, pos, src);
    }

    public int size() {
        return this.table.length;
    }
}

