/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.scanner;

import net.oneandone.mork.regexpr.Range;
import net.oneandone.sushi.util.IntBitSet;

public class State {
    private static final int INITIAL_TRANSITIONS = 16;
    private int used;
    private Object label;
    private int[] ends;
    private Range[] inputs;

    public State(Object labelInit) {
        this.label = labelInit;
        this.used = 0;
        this.ends = new int[16];
        this.inputs = new Range[16];
    }

    public State(State orig, int relocation) {
        this.label = orig.label;
        this.used = orig.used;
        this.ends = new int[orig.ends.length];
        for (int i = 0; i < this.used; ++i) {
            this.ends[i] = orig.ends[i] + relocation;
        }
        this.inputs = new Range[orig.inputs.length];
        System.arraycopy(orig.inputs, 0, this.inputs, 0, this.used);
    }

    private void ensureCapacity(int idx) {
        if (idx >= this.inputs.length) {
            int size = this.inputs.length;
            while (idx >= size) {
                if ((size *= 2) >= 0) continue;
                size = idx + 1;
                break;
            }
            int[] grownEnds = new int[size];
            System.arraycopy(this.ends, 0, grownEnds, 0, this.used);
            this.ends = grownEnds;
            Range[] grownInputs = new Range[size];
            System.arraycopy(this.inputs, 0, grownInputs, 0, this.used);
            this.inputs = grownInputs;
        }
    }

    private void checkTransition(int transition) {
        if (transition >= this.used || transition < 0) {
            throw new IllegalArgumentException();
        }
    }

    public Object getLabel() {
        return this.label;
    }

    public void setLabel(Object labelInit) {
        this.label = labelInit;
    }

    public int[] sortRanges() {
        IntBitSet tis = new IntBitSet();
        tis.addRange(0, this.size() - 1);
        int[] result = new int[this.size()];
        for (int ofs = 0; ofs < result.length; ++ofs) {
            int ti;
            int minTi = ti = tis.first();
            char minRangeFirst = this.getInput(ti).getFirst();
            ti = tis.next(ti);
            while (ti != -1) {
                Range range = this.getInput(ti);
                char cmp = range.getFirst();
                if (cmp < minRangeFirst) {
                    minRangeFirst = cmp;
                    minTi = ti;
                }
                ti = tis.next(ti);
            }
            tis.remove(minTi);
            result[ofs] = minTi;
        }
        return result;
    }

    public int size() {
        return this.used;
    }

    public int add(int state, Range input) {
        this.ensureCapacity(this.used);
        this.ends[this.used] = state;
        this.inputs[this.used] = input;
        return this.used++;
    }

    public int getEnd(int transition) {
        this.checkTransition(transition);
        return this.ends[transition];
    }

    public Range getInput(int transition) {
        this.checkTransition(transition);
        return this.inputs[transition];
    }

    public void epsilonClosure(IntBitSet states) {
        for (int transition = 0; transition < this.used; ++transition) {
            if (this.inputs[transition] != null) continue;
            states.add(this.ends[transition]);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.label == null) {
            result.append("<null>");
        } else {
            result.append(this.label.toString());
        }
        result.append("\t");
        for (int transition = 0; transition < this.used; ++transition) {
            result.append('\t');
            if (this.inputs[transition] == null) {
                result.append("<eps>");
            } else {
                result.append(this.inputs[transition].toString());
            }
            result.append("->" + this.ends[transition]);
        }
        return result.toString();
    }
}

