/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.AttributeOccurrence;
import net.oneandone.mork.semantics.AttributionBuffer;
import net.oneandone.mork.semantics.Layout;
import net.oneandone.mork.semantics.Oag;
import net.oneandone.mork.semantics.OagBuilder;
import net.oneandone.mork.semantics.Visits;
import net.oneandone.sushi.util.IntBitSet;

public class Ag {
    private final Grammar grammar;
    private final List<Object> internals;
    private final List<AttributionBuffer> attributions;

    public Ag(Grammar grammar) {
        this.grammar = grammar;
        this.internals = new ArrayList<Object>();
        this.attributions = new ArrayList<AttributionBuffer>();
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void add(AttributionBuffer ab) {
        this.attributions.add(ab);
    }

    public void add(Attribute a, int no) {
        this.internals.add(a);
        this.internals.add(no);
    }

    public Oag createSemantics(List<Attribute> firstAttrs) throws GenericException {
        Layout layout = this.createLayout(firstAttrs);
        int[][] internalAttrs = this.createInternalAttributes(layout);
        Visits[] visits = OagBuilder.run(this, layout, null);
        return new Oag(visits, internalAttrs);
    }

    private Layout createLayout(List<Attribute> firstAttrs) {
        int i;
        Layout layout = new Layout();
        int max = firstAttrs.size();
        for (i = 0; i < max; ++i) {
            layout.add(firstAttrs.get(i));
        }
        max = this.attributions.size();
        for (i = 0; i < max; ++i) {
            layout.add(this.attributions.get(i));
        }
        max = this.internals.size();
        for (i = 0; i < max; i += 2) {
            layout.add((Attribute)this.internals.get(i));
        }
        return layout;
    }

    private int[][] createInternalAttributes(Layout layout) {
        int i;
        IntBitSet symbols = new IntBitSet();
        symbols.addRange(0, this.grammar.getSymbolCount() - 1);
        int[][] internalAttrs = new int[symbols.last() + 1][];
        int s = symbols.first();
        while (s != -1) {
            int[] tmp = new int[layout.getLocationCount(s)];
            for (i = 0; i < tmp.length; ++i) {
                tmp[i] = 0;
            }
            internalAttrs[s] = tmp;
            s = symbols.next(s);
        }
        int max = this.internals.size();
        for (i = 0; i < max; i += 2) {
            Attribute attr = (Attribute)this.internals.get(i);
            Integer no = (Integer)this.internals.get(i + 1);
            internalAttrs[attr.symbol][layout.locate((Attribute)attr)] = no;
        }
        return internalAttrs;
    }

    public int getSize() {
        return this.attributions.size();
    }

    public AttributionBuffer get(int i) {
        return this.attributions.get(i);
    }

    public void getProduction(int prod, Collection<AttributionBuffer> result) {
        int max = this.attributions.size();
        for (int i = 0; i < max; ++i) {
            AttributionBuffer ab = this.get(i);
            if (ab.production != prod) continue;
            result.add(ab);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int maxProds = this.grammar.getProductionCount();
        ArrayList<AttributionBuffer> tmp = new ArrayList<AttributionBuffer>();
        for (int prod = 0; prod < maxProds; ++prod) {
            buffer.append("[" + prod + "]\t");
            this.grammar.prodToString(buffer, prod);
            buffer.append("\n");
            tmp.clear();
            this.getProduction(prod, tmp);
            int max = tmp.size();
            for (int i = 0; i < max; ++i) {
                AttributionBuffer ab = (AttributionBuffer)tmp.get(i);
                buffer.append("\t\t");
                ab.attrsToString(buffer, this.grammar.getSymbolTable());
                buffer.append('\n');
            }
            buffer.append("\n");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public AttributionBuffer findDefinition(int prod, AttributeOccurrence ao) {
        for (AttributionBuffer ab : this.attributions) {
            if (ab.production != prod || !ab.result.equals(ao)) continue;
            return ab;
        }
        return null;
    }

    public void getAttributes(int symbol, Set<Attribute> internal, Set<Attribute> synthesized, Set<Attribute> inherited) {
        Attribute a;
        for (AttributionBuffer ab : this.attributions) {
            a = ab.result.attr;
            if (a.symbol != symbol) continue;
            if (ab.result.ofs == -1) {
                synthesized.add(a);
                continue;
            }
            inherited.add(a);
        }
        int max = this.internals.size();
        for (int i = 0; i < max; i += 2) {
            a = (Attribute)this.internals.get(i);
            if (a.symbol != symbol) continue;
            internal.add(a);
        }
    }

    public boolean isInternal(Attribute attr) {
        return this.internals.indexOf(attr) != -1;
    }
}

