/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oneandone.mork.mapping.Transport;
import net.oneandone.mork.semantics.Ag;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.Compare;
import net.oneandone.mork.semantics.Merger;
import net.oneandone.mork.semantics.Occurrence;
import net.oneandone.mork.semantics.State;
import net.oneandone.mork.semantics.Type;
import net.oneandone.sushi.util.IntArrayList;

public class AgBuffer
implements Compare {
    private final List<State> states;
    private Attribute start;

    public AgBuffer(Attribute start) {
        this.start = start;
        this.states = new ArrayList<State>();
    }

    public AgBuffer(List<State> states) {
        this.states = states;
    }

    public Attribute getStart() {
        return this.start;
    }

    public void setStart(Attribute start) {
        this.start = start;
    }

    public void append(AgBuffer right) {
        for (State rightState : right.states) {
            this.add(rightState);
        }
    }

    public void add(State right) {
        State left = this.lookup(right.getAttribute());
        if (left != null) {
            throw new IllegalArgumentException();
        }
        left = new State(right);
        this.states.add(left);
    }

    public void createSemanticsBuffer(Ag sems, Transport transport) {
        for (State state : this.states) {
            state.createSemanticsBuffer(sems, transport);
        }
    }

    public AgBuffer createReduced(Attribute start) {
        AgBuffer reduced = new AgBuffer(start);
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(start);
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            State state = this.lookup(attr);
            if (state == null) continue;
            reduced.add(state);
            state.addArgAttrs(attrs);
        }
        return reduced;
    }

    public boolean isDownOptional() {
        for (State state : this.states) {
            if (!state.isDownOptional()) continue;
            return true;
        }
        return false;
    }

    public List<Attribute> getTransportAttributes() {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (State state : this.states) {
            result.add(state.getAttribute());
        }
        return result;
    }

    public State lookup(Attribute attr) {
        for (State state : this.states) {
            if (!attr.equals(state.getAttribute())) continue;
            return state;
        }
        return null;
    }

    public Attribute merge(List<AgBuffer> copyBuffers, int symbol, Type mergedType) {
        HashMap<Attribute, Merger> mapping = new HashMap<Attribute, Merger>();
        ArrayList<Merger> mergers = new ArrayList<Merger>();
        int max = copyBuffers.size();
        for (int i = 0; i < max; ++i) {
            copyBuffers.get(i).createMergers(mergers, mapping, mergedType);
        }
        this.runMergers(mergers, mapping);
        Merger merger = Merger.forSymbol(mergers, symbol);
        if (merger == null) {
            throw new IllegalStateException();
        }
        return merger.dest;
    }

    private void createMergers(List<Merger> mergers, Map<Attribute, Merger> mapping, Type mergedType) {
        for (State state : this.states) {
            Attribute attr = state.getAttribute();
            Merger merger = Merger.forSymbol(mergers, attr.symbol);
            if (merger == null) {
                merger = new Merger(attr.symbol, mergedType);
                mergers.add(merger);
            }
            merger.source.add(state);
            mapping.put(attr, merger);
        }
    }

    private void runMergers(List<Merger> mergers, Map<Attribute, Merger> mapping) {
        int max = mergers.size();
        for (int i = 0; i < max; ++i) {
            Merger merger = mergers.get(i);
            State state = State.merge(mapping, merger.source);
            this.states.add(state);
        }
    }

    public int compare(AgBuffer rightSemantics) {
        Attribute left = this.start;
        Attribute right = rightSemantics.start;
        if (left.symbol != right.symbol) {
            throw new IllegalArgumentException();
        }
        ArrayList<Attribute> lefts = new ArrayList<Attribute>();
        lefts.add(left);
        ArrayList<Attribute> rights = new ArrayList<Attribute>();
        rights.add(right);
        int result = 1;
        for (int i = 0; i < rights.size(); ++i) {
            if (lefts.size() != rights.size()) {
                throw new IllegalStateException();
            }
            int cmp = this.localCompare((Attribute)lefts.get(i), (Attribute)rights.get(i), rightSemantics, lefts, rights);
            if (cmp == 1) continue;
            if (cmp == 8) {
                return 8;
            }
            if (result == 1) {
                result = cmp;
                continue;
            }
            return 8;
        }
        if (result == 1) {
            return 8;
        }
        return result;
    }

    private int localCompare(Attribute left, Attribute right, AgBuffer rightSemantics, List<Attribute> nextLefts, List<Attribute> nextRights) {
        if (left.symbol != right.symbol) {
            throw new IllegalStateException();
        }
        State leftState = this.lookup(left);
        State rightState = rightSemantics.lookup(right);
        if (leftState == null && rightState == null) {
            return 1;
        }
        if (leftState == null || rightState == null) {
            throw new IllegalStateException("different number of productions");
        }
        return leftState.compare(rightState, nextLefts, nextRights);
    }

    public String toRawString() {
        return this.toString(true);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean raw) {
        StringBuilder buf = new StringBuilder();
        for (State state : this.states) {
            buf.append(state.toString(raw));
        }
        return buf.toString();
    }

    public Attribute cloneAttributes(AgBuffer orig, Type type, Attribute seed) {
        Attribute attr;
        HashMap<Attribute, Attribute> map = new HashMap<Attribute, Attribute>();
        for (State state : orig.states) {
            attr = state.getAttribute();
            map.put(attr, new Attribute(attr.symbol, null, type));
        }
        for (State state : orig.states) {
            State newState = state.cloneAttributeTransport(map);
            this.states.add(newState);
        }
        attr = (Attribute)map.get(seed);
        if (attr == null) {
            throw new IllegalArgumentException();
        }
        return attr;
    }

    public int calcCard(Attribute root) {
        Occurrence occ = this.calcOccurrence(root);
        return occ.card();
    }

    public Occurrence calcOccurrence(Attribute start) {
        Occurrence occ = this.calcOccurrence(new ArrayList<Attribute>(), start);
        if (occ == null) {
            throw new IllegalStateException();
        }
        return occ;
    }

    public Occurrence calcOccurrence(List<Attribute> stack, Attribute start) {
        State state = this.lookup(start);
        if (state == null) {
            return Occurrence.ONE;
        }
        stack.add(start);
        Occurrence occ = state.calcOccurrence(this, stack);
        stack.remove(stack.size() - 1);
        return occ;
    }

    public int getWidth(Attribute attr) {
        State state = this.lookup(attr);
        if (state == null) {
            return 1;
        }
        return state.maxOcc;
    }

    public void calcOccurrences() {
        boolean changes;
        for (State state : this.states) {
            state.minOcc = 1;
            state.maxOcc = 1;
        }
        do {
            changes = false;
            for (State state : this.states) {
                if (!state.recalcOccurrence(this)) continue;
                changes = true;
            }
        } while (changes);
    }

    public Attribute createSequence(Attribute start, int seq, AgBuffer result) {
        Attribute attr = this.createSequence(start, seq, new ArrayList<State>(), new ArrayList<State>(), result);
        return attr;
    }

    private Attribute createSequence(Attribute attr, int seq, List<State> origStack, List<State> clonedStack, AgBuffer result) {
        State orig = this.lookup(attr);
        if (orig != null) {
            State clone;
            int idx = origStack.indexOf(orig);
            if (idx != -1) {
                clone = clonedStack.get(idx);
            } else {
                clone = State.cloneEmpty(orig);
                ArrayList<Attribute> nextAttrs = new ArrayList<Attribute>();
                IntArrayList nextOfss = new IntArrayList();
                IntArrayList nextSeqs = new IntArrayList();
                orig.getSequence(seq, nextAttrs, nextOfss, nextSeqs, this);
                int altCount = nextAttrs.size();
                origStack.add(orig);
                clonedStack.add(clone);
                for (int alt = 0; alt < altCount; ++alt) {
                    Attribute nextAttr = (Attribute)nextAttrs.get(alt);
                    if (nextAttr == null) continue;
                    int nextSeq = nextSeqs.get(alt);
                    Attribute tmp = this.createSequence(nextAttr, nextSeq, origStack, clonedStack, result);
                    clone.addBlind(alt, tmp, nextOfss.get(alt));
                }
                origStack.remove(origStack.size() - 1);
                clonedStack.remove(clonedStack.size() - 1);
                result.states.add(clone);
            }
            return clone.getAttribute();
        }
        return attr;
    }
}

